/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished;

import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.StorageJarBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="refurbished_furniture")
public class NeoForgeEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().is((Item)ModItems.WRENCH.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        StorageJarBlockEntity storageJar;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (player.isCrouching()) {
            return;
        }
        if (event.getAction() != PlayerInteractEvent.LeftClickBlock.Action.START) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof StorageJarBlockEntity && !(storageJar = (StorageJarBlockEntity)blockEntity).isEmpty()) {
            if (!level.isClientSide()) {
                storageJar.popItem(player.getDirection().getOpposite());
            }
        } else {
            CuttingBoardBlockEntity cuttingBoard;
            blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CuttingBoardBlockEntity && !(cuttingBoard = (CuttingBoardBlockEntity)blockEntity).isEmpty() && !level.isClientSide()) {
                cuttingBoard.removeItem();
            }
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (Services.PLATFORM.isModLoaded("jei")) {
            event.sendRecipes(new RecipeType[]{(RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get(), (RecipeType)ModRecipeTypes.GRILL_COOKING.get(), (RecipeType)ModRecipeTypes.FREEZER_SOLIDIFYING.get(), (RecipeType)ModRecipeTypes.TOASTER_HEATING.get(), (RecipeType)ModRecipeTypes.CUTTING_BOARD_SLICING.get(), (RecipeType)ModRecipeTypes.CUTTING_BOARD_COMBINING.get(), (RecipeType)ModRecipeTypes.MICROWAVE_HEATING.get(), (RecipeType)ModRecipeTypes.FRYING_PAN_COOKING.get(), (RecipeType)ModRecipeTypes.OVEN_BAKING.get()});
        }
    }
}

