/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalEntityBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ToiletBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class ToiletBlock
extends FurnitureHorizontalEntityBlock {
    public ToiletBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape seatShape = Block.box((double)0.0, (double)4.0, (double)2.0, (double)16.0, (double)10.0, (double)14.0);
        VoxelShape tankShape = Block.box((double)11.0, (double)10.0, (double)2.0, (double)16.0, (double)17.0, (double)14.0);
        VoxelShape lidShape = Block.box((double)10.0, (double)17.0, (double)2.0, (double)16.0, (double)19.0, (double)14.0);
        VoxelShape supportShape = Block.box((double)3.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)12.0);
        VoxelShape combinedShape = VoxelShapeHelper.combine(List.of(seatShape, tankShape, lidShape, supportShape));
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> VoxelShapeHelper.rotateHorizontally(combinedShape, (Direction)state.getValue((Property)DIRECTION)))));
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Vec3 hit;
        ToiletBlockEntity toilet;
        InteractionResult toiletResult;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ToiletBlockEntity && (toiletResult = (toilet = (ToiletBlockEntity)blockEntity).interact(player, hand, result)).consumesAction()) {
            return toiletResult;
        }
        if (!level.isClientSide() && (hit = result.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos))).y() <= 0.625 && Seat.sit(player, pos, Utils.pixels(10.0), ((Direction)state.getValue((Property)DIRECTION)).getOpposite())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        ToiletBlockEntity toilet;
        FluidContainer container;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ToiletBlockEntity && (container = (toilet = (ToiletBlockEntity)blockEntity).getFluidContainer()) != null) {
            this.handleEvent(level, pos, container);
        }
    }

    private void handleEvent(ServerLevel level, BlockPos pos, FluidContainer container) {
        SoundEvent event = Services.FLUID.getBucketEmptySound((Fluid)Fluids.WATER);
        if (Fluids.WATER.isSame(container.getStoredFluid()) && event != null) {
            Vec3 center = Vec3.atCenterOf((Vec3i)pos);
            level.sendParticles((ParticleOptions)ParticleTypes.SPLASH, center.x, center.y, center.z, 10, 0.0, 0.0, 0.0, 0.0);
            level.playSound(null, pos, event, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (Fluids.LAVA.isSame(container.getStoredFluid())) {
            Vec3 center = Vec3.atCenterOf((Vec3i)pos);
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, center.x, center.y, center.z, 5, 0.0, 0.0, 0.0, 0.0);
            level.playSound(null, pos, SoundEvents.GENERIC_BURN, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ToiletBlockEntity(pos, state);
    }
}

