/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.mrcrayfish.framework.api.config.event.FrameworkConfigEvents;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.ElectricBlockEntityRenderer;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModRenderPipelines;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import com.mrcrayfish.furniture.refurbished.electricity.LinkHitResult;
import com.mrcrayfish.furniture.refurbished.electricity.NodeHitResult;
import com.mrcrayfish.furniture.refurbished.item.WrenchItem;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDeleteLink;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectiond;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class LinkHandler {
    private static final ResourceLocation POWERABLE_AREA = Utils.resource("textures/misc/powerable_area.png");
    private static final ResourceLocation UNPOWERABLE_AREA = Utils.resource("textures/misc/unpowerable_area.png");
    private static final int DEFAULT_LINK_COLOUR = -1;
    private static final int SUCCESS_LINK_COLOUR = -4849844;
    private static final int ERROR_LINK_COLOUR = -3983818;
    private static final double NEAR_DISTANCE = 10.0;
    private static LinkHandler instance;
    @Nullable
    private BlockPos lastNodePos;
    private HitResult result;
    private double linkLength;
    private boolean linkInsideArea;
    private final Set<BlockPos> sourcePositions = new HashSet<BlockPos>();
    private final Set<BlockPos> lastSourcePositions = new HashSet<BlockPos>();
    private VoxelShape cachedPowerableAreaShape;

    public static LinkHandler get() {
        if (instance == null) {
            instance = new LinkHandler();
        }
        return instance;
    }

    private LinkHandler() {
        FrameworkConfigEvents.RELOAD.register(object -> {
            if (object == Config.SERVER) {
                this.lastSourcePositions.clear();
                this.cachedPowerableAreaShape = null;
            }
        });
    }

    public void setLinkingNode(BlockPos pos) {
        this.lastNodePos = pos;
    }

    public boolean isLinkingNode(IElectricityNode node) {
        return this.lastNodePos != null && this.lastNodePos.equals((Object)node.getNodePosition());
    }

    public boolean isLinking() {
        return this.lastNodePos != null;
    }

    public boolean isLinkInsidePowerableArea() {
        return this.linkInsideArea;
    }

    @Nullable
    public IElectricityNode getLinkingNode(Level level) {
        if (this.lastNodePos == null) {
            return null;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.lastNodePos);
        if (blockEntity instanceof IElectricityNode) {
            IElectricityNode node = (IElectricityNode)blockEntity;
            return node;
        }
        return null;
    }

    public double getLinkLength() {
        return this.lastNodePos != null ? this.linkLength : 0.0;
    }

    public void beforeRender(float partialTick) {
        this.updateHitResult(partialTick);
        this.updatePowerSources();
        this.updateLinkState(partialTick);
    }

    private void updateHitResult(float partialTick) {
        HitResult last = this.result;
        this.result = null;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.level != null && mc.gameMode != null && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get())) {
            double range = mc.player.blockInteractionRange();
            NodeHitResult newResult = WrenchItem.performNodeRaycast((Level)mc.level, (Player)mc.player, range, partialTick);
            if (newResult.getType() == HitResult.Type.MISS) {
                newResult = this.performLinkRaycast((Player)mc.player, partialTick, range);
            }
            if (newResult.getType() != HitResult.Type.MISS) {
                this.playHoverSound(last, newResult, (Player)mc.player, (Level)mc.level);
                this.result = newResult;
            }
        }
    }

    private void playHoverSound(@Nullable HitResult oldResult, @Nullable HitResult newResult, Player player, Level level) {
        if ((oldResult == null || !oldResult.equals(newResult)) && newResult instanceof LinkHitResult) {
            if (this.lastNodePos != null) {
                return;
            }
            Vec3 pos = newResult.getLocation();
            float pitch = 1.0f + 0.05f * level.random.nextFloat();
            level.playSound((Entity)player, pos.x, pos.y, pos.z, (SoundEvent)ModSounds.ITEM_WRENCH_HOVER_LINK.get(), SoundSource.BLOCKS, 1.0f, pitch);
        }
    }

    private void updatePowerSources() {
        Connection connection;
        this.sourcePositions.clear();
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        IElectricityNode linking = this.getLinkingNode((Level)mc.level);
        this.addSourceNodePositions(this.sourcePositions, this.getLinkingNode((Level)mc.level));
        IElectricityNode target = this.getTargetNode();
        if (linking != null && !linking.isSourceNode()) {
            if (target != null && target.isSourceNode()) {
                this.sourcePositions.clear();
            }
            if (this.sourcePositions.isEmpty()) {
                this.addSourceNodePositions(this.sourcePositions, target);
            }
        }
        if (linking == null && target == null && (connection = this.getTargetConnection()) != null && connection.isCrossingPowerableZone((Level)mc.level)) {
            Sets.SetView delta;
            IElectricityNode a = connection.getNodeA((Level)mc.level);
            IElectricityNode b = connection.getNodeB((Level)mc.level);
            if (a != null && b != null && !(delta = Sets.symmetricDifference(a.getPowerSources(), b.getPowerSources())).isEmpty()) {
                this.sourcePositions.add((BlockPos)List.copyOf(delta).get(0));
            }
        }
    }

    private void updateLinkState(float partialTick) {
        this.linkInsideArea = false;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (this.sourcePositions.isEmpty()) {
            this.linkInsideArea = true;
        } else if (this.lastNodePos != null) {
            this.linkInsideArea = this.sourcePositions.stream().anyMatch(pos -> {
                AABB box = ISourceNode.createPowerableZone((Level)mc.level, pos);
                return box.contains(this.lastNodePos.getCenter()) && box.contains(this.getLinkEnd((Player)mc.player, partialTick));
            });
        } else {
            HitResult hitResult = this.result;
            if (hitResult instanceof LinkHitResult) {
                LinkHitResult hitResult2 = (LinkHitResult)hitResult;
                Connection connection = hitResult2.getConnection();
                Vec3 start = connection.getPosA().getCenter();
                Vec3 end = connection.getPosB().getCenter();
                this.linkInsideArea = this.sourcePositions.stream().anyMatch(pos -> {
                    AABB box = ISourceNode.createPowerableZone((Level)mc.level, pos);
                    return box.contains(start) && box.contains(end);
                });
            }
        }
    }

    private void addSourceNodePositions(Set<BlockPos> positions, @Nullable IElectricityNode start) {
        if (start == null) {
            return;
        }
        if (start.isSourceNode()) {
            positions.add(start.getNodePosition());
            return;
        }
        int searchLimit = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
        IElectricityNode.searchNodes(start, searchLimit, true, node -> !node.isSourceNode(), IElectricityNode::isSourceNode).forEach(node -> positions.add(node.getNodePosition()));
    }

    public boolean isTargetNode(IElectricityNode node) {
        NodeHitResult nodeResult;
        HitResult hitResult = this.result;
        return hitResult instanceof NodeHitResult && (nodeResult = (NodeHitResult)hitResult).getNode() == node;
    }

    @Nullable
    public IElectricityNode getTargetNode() {
        IElectricityNode iElectricityNode;
        HitResult hitResult = this.result;
        if (hitResult instanceof NodeHitResult) {
            NodeHitResult nodeResult = (NodeHitResult)hitResult;
            iElectricityNode = nodeResult.getNode();
        } else {
            iElectricityNode = null;
        }
        return iElectricityNode;
    }

    @Nullable
    public Connection getTargetConnection() {
        Connection connection;
        HitResult hitResult = this.result;
        if (hitResult instanceof LinkHitResult) {
            LinkHitResult linkResult = (LinkHitResult)hitResult;
            connection = linkResult.getConnection();
        } else {
            connection = null;
        }
        return connection;
    }

    public void render(Player player, PoseStack poseStack, DeltaTracker tracker) {
        if (!player.isAlive() || !LinkHandler.isHoldingWrench()) {
            this.lastNodePos = null;
        }
        this.renderPowerableArea(poseStack, player, tracker.getGameTimeDeltaPartialTick(true));
        if (this.lastNodePos != null) {
            this.renderUnfinishedLink(player, tracker);
        }
    }

    private void renderUnfinishedLink(Player player, DeltaTracker tracker) {
        DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
        renderer.deferDraw((pose, consumer) -> {
            if (this.lastNodePos == null) {
                return;
            }
            Vec3 start = Vec3.atCenterOf((Vec3i)this.lastNodePos);
            Vec3 end = this.getLinkEnd(player, tracker.getGameTimeDeltaPartialTick(true));
            Vec3 delta = end.subtract(start);
            this.linkLength = delta.length();
            double yaw = Math.atan2(-delta.z, delta.x) + Math.PI;
            double pitch = Math.atan2(delta.horizontalDistance(), delta.y) + 1.5707963705062866;
            pose.pushPose();
            pose.translate(start.x, start.y, start.z);
            pose.mulPose((Quaternionfc)Axis.YP.rotation((float)yaw));
            pose.mulPose((Quaternionfc)Axis.ZP.rotation((float)pitch));
            int color = this.getLinkColour(player.level());
            Matrix4f matrix = pose.last().pose();
            renderer.drawColouredBox(matrix, (VertexConsumer)consumer, new AABB(0.0, -0.03125, -0.03125, delta.length(), 0.03125, 0.03125), color, 0.8f);
            renderer.drawColouredBox(matrix, (VertexConsumer)consumer, new AABB(0.0, -0.03125, -0.03125, delta.length(), 0.03125, 0.03125).inflate(0.03125), color, 0.6f);
            pose.popPose();
        });
    }

    private Vec3 getLinkEnd(Player player, float partialTick) {
        IElectricityNode node = this.getTargetNode();
        if (node != null && !this.isLinkingNode(node) && this.canLinkToNode(player.level(), node)) {
            return node.getNodePosition().getCenter();
        }
        return player.getViewVector(partialTick).normalize().scale(1.5).add(player.getEyePosition(partialTick));
    }

    public int getLinkColour(Level level) {
        IElectricityNode linking = this.getLinkingNode(level);
        if (linking == null) {
            return -1;
        }
        if (this.linkLength > 512.0) {
            return -3983818;
        }
        IElectricityNode target = this.getTargetNode();
        if (target != null && !this.isLinkingNode(target)) {
            if (this.canLinkToNode(level, target)) {
                return -4849844;
            }
            return -3983818;
        }
        if (!this.linkInsideArea) {
            return -3983818;
        }
        return -1;
    }

    public boolean canLinkToNode(Level level, IElectricityNode target) {
        IElectricityNode lastNode;
        if (this.lastNodePos != null && (lastNode = this.getLinkingNode(level)) != null && target != null && lastNode != target) {
            if (target.isSourceNode() && lastNode.isSourceNode()) {
                return false;
            }
            if (target.isNodeConnectionLimitReached()) {
                return false;
            }
            return !lastNode.isConnectedToNode(target);
        }
        return false;
    }

    private HitResult performLinkRaycast(Player player, float partialTick, double range) {
        double closestDistance = Double.POSITIVE_INFINITY;
        Connection closestConnection = null;
        Vec3 hit = Vec3.ZERO;
        Set<Connection> connections = ElectricBlockEntityRenderer.getDrawnConnections();
        for (Connection connection : connections) {
            Vec3 rayStart = player.getEyePosition(partialTick);
            Vec3 rayEnd = rayStart.add(player.getViewVector(partialTick).normalize().scale(range));
            Vec3 linkStart = connection.getPosA().getCenter();
            Vec3 linkEnd = connection.getPosB().getCenter();
            Vector3d result = new Vector3d();
            double squareDistance = Intersectiond.findClosestPointsLineSegments((double)rayStart.x, (double)rayStart.y, (double)rayStart.z, (double)rayEnd.x, (double)rayEnd.y, (double)rayEnd.z, (double)linkStart.x, (double)linkStart.y, (double)linkStart.z, (double)linkEnd.x, (double)linkEnd.y, (double)linkEnd.z, (Vector3d)new Vector3d(), (Vector3d)result);
            double distance = Math.sqrt(squareDistance);
            if (!(distance < 0.1) || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestConnection = connection;
            hit = new Vec3(result.x, result.y, result.z);
        }
        return new LinkHitResult(hit, closestConnection);
    }

    public boolean onWrenchLeftClick(Level level) {
        LinkHitResult linkResult;
        Connection connection;
        HitResult hitResult;
        if (!this.isLinking() && (hitResult = this.result) instanceof LinkHitResult && (connection = (linkResult = (LinkHitResult)hitResult).getConnection()) != null) {
            Vec3 hit = linkResult.getLocation();
            level.playLocalSound(hit.x, hit.y, hit.z, (SoundEvent)ModSounds.ITEM_WRENCH_REMOVE_LINK.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            Network.getPlay().sendToServer((Object)new MessageDeleteLink(connection.getPosA(), connection.getPosB()));
            return true;
        }
        return false;
    }

    @Nullable
    private VoxelShape getPowerableAreaShape() {
        Minecraft mc = Minecraft.getInstance();
        if (this.sourcePositions.isEmpty() || mc.level == null) {
            return null;
        }
        if (this.lastSourcePositions.equals(this.sourcePositions)) {
            return this.cachedPowerableAreaShape;
        }
        this.sourcePositions.stream().map(pos -> ISourceNode.createPowerableZone((Level)mc.level, pos)).map(aabb -> {
            VoxelShape shape1 = Shapes.create((AABB)aabb);
            VoxelShape shape2 = Shapes.create((AABB)aabb.inflate(0.001));
            return Pair.of((Object)shape1, (Object)shape2);
        }).reduce((p1, p2) -> {
            VoxelShape shape1 = Shapes.joinUnoptimized((VoxelShape)((VoxelShape)p1.first()), (VoxelShape)((VoxelShape)p2.first()), (BooleanOp)BooleanOp.OR);
            VoxelShape shape2 = Shapes.joinUnoptimized((VoxelShape)((VoxelShape)p1.second()), (VoxelShape)((VoxelShape)p2.second()), (BooleanOp)BooleanOp.OR);
            return Pair.of((Object)shape1, (Object)shape2);
        }).map(pair -> Shapes.joinUnoptimized((VoxelShape)((VoxelShape)pair.first()), (VoxelShape)((VoxelShape)pair.second()), (BooleanOp)BooleanOp.ONLY_SECOND)).ifPresent(shape -> {
            this.cachedPowerableAreaShape = shape;
        });
        this.lastSourcePositions.clear();
        this.lastSourcePositions.addAll(this.sourcePositions);
        return this.cachedPowerableAreaShape;
    }

    private void renderPowerableArea(PoseStack poseStack, Player player, float partialTick) {
        block19: {
            float areaAlpha;
            VoxelShape areaShape = this.getPowerableAreaShape();
            if (areaShape == null) {
                return;
            }
            Vec3 eyePos = player.getEyePosition(partialTick);
            double nearDistanceSqr = 100.0;
            float f = areaAlpha = !this.linkInsideArea ? 1.0f : areaShape.closestPointTo(eyePos).map(vec -> vec.distanceToSqr(eyePos)).map(val -> Float.valueOf(1.0f - (float)Mth.clamp((double)(val / nearDistanceSqr), (double)0.0, (double)1.0))).orElse(Float.valueOf(0.0f)).floatValue();
            if (areaAlpha <= 0.0f) {
                return;
            }
            areaAlpha = 1.0f - (float)Math.pow(1.0f - areaAlpha, 5.0);
            boolean shaders = DeferredElectricRenderer.get().isIrisShadersEnabled();
            RenderPipeline pipeline = shaders ? RenderPipelines.WORLD_BORDER : ModRenderPipelines.POWERABLE_AREA;
            try (ByteBufferBuilder quadBuilder = new ByteBufferBuilder(pipeline.getVertexFormat().getVertexSize() * 4);){
                BufferBuilder vertexBuilder = new BufferBuilder(quadBuilder, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
                areaShape.toAabbs().forEach(box -> this.drawTexturedBox(poseStack, (VertexConsumer)vertexBuilder, (AABB)box));
                try (MeshData data = vertexBuilder.build();){
                    if (data == null) break block19;
                    RenderTarget mainTarget = Minecraft.getInstance().getMainRenderTarget();
                    GpuTextureView mainColor = mainTarget.getColorTextureView();
                    GpuTextureView mainDepth = mainTarget.getDepthTextureView();
                    GpuBufferSlice slice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 0.6f * areaAlpha), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                    RenderSystem.AutoStorageIndexBuffer autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)pipeline.getVertexFormatMode());
                    VertexFormat.IndexType indexType = autoIndexBuffer.type();
                    GpuBuffer indexBuffer = autoIndexBuffer.getBuffer(data.drawState().indexCount());
                    GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Powerable Area", 40, data.vertexBuffer().remaining());
                    RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer.slice(), data.vertexBuffer());
                    AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(this.linkInsideArea ? POWERABLE_AREA : UNPOWERABLE_AREA);
                    try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "SUM SUM", mainColor, OptionalInt.empty(), mainDepth, OptionalDouble.empty());){
                        RenderSystem.bindDefaultUniforms((RenderPass)pass);
                        pass.setPipeline(pipeline);
                        pass.setVertexBuffer(0, vertexBuffer);
                        pass.setUniform("DynamicTransforms", slice);
                        pass.setIndexBuffer(indexBuffer, indexType);
                        pass.bindSampler("Sampler0", texture.getTextureView());
                        pass.drawIndexed(0, 0, data.drawState().indexCount(), 1);
                    }
                }
            }
        }
    }

    private void drawTexturedBox(PoseStack poseStack, VertexConsumer consumer, AABB box) {
        Matrix4f matrix = poseStack.last().pose();
        float offset = (float)Util.getMillis() * 0.001f;
        float width = (float)(box.maxX - box.minX);
        float height = (float)(box.maxY - box.minY);
        if ((double)width > 0.01) {
            consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(0.0f, height + offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(width, height + offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(width, offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(0.0f, offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(0.0f, height + offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(width, height + offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(width, offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(0.0f, offset);
        }
        if ((double)(width = (float)(box.maxZ - box.minZ)) > 0.01) {
            consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(0.0f, height + offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(width, height + offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(width, offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(0.0f, offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(0.0f, height + offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(width, height + offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(width, offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(0.0f, offset);
        }
        width = (float)(box.maxX - box.minX);
        height = (float)(box.maxZ - box.minZ);
        if ((double)width > 0.01) {
            consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setUv(height, width + offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setUv(height, offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setUv(0.0f, offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setUv(0.0f, width + offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setUv(0.0f, height + offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setUv(width, height + offset);
            consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setUv(width, offset);
            consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setUv(0.0f, offset);
        }
    }

    public static boolean isHoldingWrench() {
        Minecraft mc = Minecraft.getInstance();
        return mc.player != null && mc.player.getMainHandItem().is((Item)ModItems.WRENCH.get());
    }
}

