/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mrcrayfish.furniture.refurbished.image.TextureCache;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;

public class NeoForgeRenderType {
    private static final Function<ResourceLocation, RenderType> TELEVISION_SCREEN = Util.memoize(id -> RenderType.create((String)"refurbished_furniture_television_screen", (int)0x200000, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.SOLID, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderType.LIGHTMAP).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(id, false)).createCompositeState(true)));
    private static final Function<ResourceLocation, RenderType> PALETTE_IMAGE = id -> RenderType.create((String)"refurbished_furniture_palette_image", (int)0x200000, (boolean)false, (boolean)false, (RenderPipeline)RenderPipelines.CUTOUT, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(RenderType.LIGHTMAP).setTextureState((RenderStateShard.EmptyTextureStateShard)new DoorMatTextureStateShard((ResourceLocation)id)).createCompositeState(true));

    public static RenderType televisionScreen(ResourceLocation id) {
        return TELEVISION_SCREEN.apply(id);
    }

    public static RenderType createPaletteImage(ResourceLocation id) {
        return PALETTE_IMAGE.apply(id);
    }

    private static class DoorMatTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        private final Optional<ResourceLocation> texture;

        public DoorMatTextureStateShard(ResourceLocation id) {
            super(() -> {
                AbstractTexture texture = TextureCache.get().getTexture(id);
                texture.setFilter(false, false);
                RenderSystem.setShaderTexture((int)0, (GpuTextureView)texture.getTextureView());
            }, () -> {});
            this.texture = Optional.of(id);
        }

        protected Optional<ResourceLocation> cutoutTexture() {
            return this.texture;
        }
    }
}

