/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.inventory.IBakingMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AbstractStoveScreen<T extends AbstractContainerMenu & IPowerSwitchMenu>
extends ElectricityContainerScreen<T> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/container/stove.png");
    protected OnOffSlider slider;

    public AbstractStoveScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected void init() {
        super.init();
        this.initWidgets();
    }

    protected void initWidgets() {
        this.slider = (OnOffSlider)this.addRenderableWidget((GuiEventListener)new OnOffSlider(this.leftPos + this.imageWidth - 22 - 6, this.topPos + 5, Components.GUI_TOGGLE_POWER, btn -> Network.getPlay().sendToServer((Object)new MessageTogglePower())));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((IPowerSwitchMenu)this.menu).isEnabled());
        super.render(graphics, mouseX, mouseY, partialTick);
        this.afterRender(graphics, mouseX, mouseY, partialTick);
    }

    protected void afterRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int offset = ((IElectricityMenu)this.menu).isPowered() && ((IPowerSwitchMenu)this.menu).isEnabled() ? (int)(Util.getMillis() / 100L) % 3 : 0;
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos + 32, this.topPos + 23, 176.0f, (float)(16 + offset * 40), 40, 40, 256, 256);
        for (int i = 0; i < 3; ++i) {
            int progress = ((IBakingMenu)this.menu).getBakingProgress(i);
            int totalProgress = ((IBakingMenu)this.menu).getTotalBakingProgress(i);
            if (totalProgress == 0) continue;
            int height = (int)Math.ceil(16.0f * ((float)progress / (float)totalProgress));
            graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos + 84 + i * 18, this.topPos + 36, 190.0f, 0.0f, 17, height, 256, 256);
        }
    }
}

