/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.CuttingBoardBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class CuttingBoardBlockEntityRenderer
implements BlockEntityRenderer<CuttingBoardBlockEntity> {
    private final ItemRenderer renderer;
    private final RandomSource random = RandomSource.create();

    public CuttingBoardBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.getItemRenderer();
    }

    public void render(CuttingBoardBlockEntity cuttingBoard, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay, Vec3 camera) {
        Direction direction = (Direction)cuttingBoard.getBlockState().getValue((Property)CuttingBoardBlock.DIRECTION);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.078125, 0.5);
        poseStack.mulPose((Quaternionfc)direction.getRotation());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (int i = 0; i < cuttingBoard.getContainerSize(); ++i) {
            ItemStack stack = cuttingBoard.getItem(i);
            if (stack.isEmpty()) continue;
            this.random.setSeed((long)(cuttingBoard.getBlockPos().hashCode() + i));
            poseStack.pushPose();
            if (stack.is(ModTags.Items.DISPLAY_AS_BLOCK)) {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotation(1.5707964f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.0, 0.4375, 0.0);
            } else {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotation((float)this.random.nextGaussian() * (float)Math.PI * 0.025f));
            }
            this.renderer.renderStatic(stack, ItemDisplayContext.NONE, light, overlay, poseStack, source, cuttingBoard.getLevel(), 0);
            poseStack.popPose();
            poseStack.translate(0.0, 0.0, stack.is(ModTags.Items.DISPLAY_AS_BLOCK) ? 0.5 : 0.0625);
        }
        poseStack.popPose();
    }
}

