/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleContainerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.slot.FuelSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ElectricityGeneratorMenu
extends SimpleContainerMenu
implements IPowerSwitchMenu {
    private final ContainerData data;
    private final Level level;

    public ElectricityGeneratorMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(6));
    }

    public ElectricityGeneratorMenu(int windowId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ModMenuTypes.ELECTRICITY_GENERATOR.get(), windowId, container);
        ElectricityGeneratorMenu.checkContainerSize((Container)container, (int)1);
        ElectricityGeneratorMenu.checkContainerDataCount((ContainerData)data, (int)6);
        container.startOpen(playerInventory.player);
        this.data = data;
        this.level = playerInventory.player.level();
        this.addSlot(new FuelSlot(container, this.level, 0, 26, 42));
        this.addPlayerInventorySlots(8, 84, playerInventory);
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true) : (this.isFuel(slotStack) ? !this.moveItemStackTo(slotStack, 0, this.container.getContainerSize(), false) : (slotIndex < this.container.getContainerSize() + 27 ? !this.moveItemStackTo(slotStack, this.container.getContainerSize() + 27, this.slots.size(), false) : !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size() - 9, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    private boolean isFuel(ItemStack stack) {
        return this.level.fuelValues().isFuel(stack);
    }

    public int getEnergy() {
        return this.data.get(0);
    }

    public int getTotalEnergy() {
        return this.data.get(1);
    }

    @Override
    public boolean isEnabled() {
        return this.data.get(2) != 0;
    }

    public boolean isOverloaded() {
        return this.data.get(3) != 0;
    }

    public boolean isPowered() {
        return this.data.get(4) != 0;
    }

    public int getNodeCount() {
        return this.data.get(5);
    }

    @Override
    public void toggle() {
        Container container = this.container;
        if (container instanceof IPowerSwitch) {
            IPowerSwitch powerSwitch = (IPowerSwitch)container;
            powerSwitch.togglePower();
        }
    }
}

