/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeBookTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipePropertySets;
import com.mrcrayfish.furniture.refurbished.crafting.FreezerSolidifyingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.IContainerHolder;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IPowerSwitchMenu;
import com.mrcrayfish.furniture.refurbished.inventory.IProcessingMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleRecipeContainerMenu;
import com.mrcrayfish.furniture.refurbished.inventory.slot.ResultSlot;
import com.mrcrayfish.furniture.refurbished.platform.Services;
import java.util.List;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class FreezerMenu
extends SimpleRecipeContainerMenu
implements IPowerSwitchMenu,
IElectricityMenu,
IContainerHolder,
IProcessingMenu {
    private final ContainerData data;
    private final Level level;
    private final RecipePropertySet recipeTest;

    public FreezerMenu(int windowId, Inventory playerInventory) {
        this(windowId, playerInventory, (Container)new SimpleContainer(2), (ContainerData)new SimpleContainerData(4));
    }

    public FreezerMenu(int windowId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ModMenuTypes.FREEZER.get(), windowId, container);
        FreezerMenu.checkContainerSize((Container)container, (int)2);
        FreezerMenu.checkContainerDataCount((ContainerData)data, (int)4);
        container.startOpen(playerInventory.player);
        this.data = data;
        this.level = playerInventory.player.level();
        this.recipeTest = this.level.recipeAccess().propertySet(ModRecipePropertySets.FREEZER_INPUT);
        this.addSlot(new Slot(container, 0, 48, 35));
        this.addSlot(new ResultSlot(container, 1, 108, 35));
        this.addPlayerInventorySlots(8, 84, playerInventory);
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (slotIndex < this.container.getContainerSize() ? !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size(), true) : (this.recipeTest.test(slotStack) ? !this.moveItemStackTo(slotStack, 0, this.container.getContainerSize(), false) : (slotIndex < this.container.getContainerSize() + 27 ? !this.moveItemStackTo(slotStack, this.container.getContainerSize() + 27, this.slots.size(), false) : !this.moveItemStackTo(slotStack, this.container.getContainerSize(), this.slots.size() - 9, false)))) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    @Override
    public int getProcessTime() {
        return this.data.get(2);
    }

    @Override
    public int getMaxProcessTime() {
        return this.data.get(3);
    }

    @Override
    public boolean isPowered() {
        return this.data.get(0) != 0;
    }

    @Override
    public boolean isEnabled() {
        return this.data.get(1) != 0;
    }

    @Override
    public void toggle() {
        Container container = this.container;
        if (container instanceof IPowerSwitch) {
            IPowerSwitch powerSwitch = (IPowerSwitch)container;
            powerSwitch.togglePower();
        }
    }

    @Override
    public Container container() {
        return this.container;
    }

    public void fillCraftSlotsStackedContents(StackedItemContents contents) {
        if (this.container instanceof StackedContentsCompatible) {
            ((StackedContentsCompatible)this.container).fillStackedContents(contents);
        }
    }

    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean useMax, boolean creativeMode, RecipeHolder<?> holder, ServerLevel level, Inventory inventory) {
        RecipeHolder<?> recipeHolder = holder;
        List<Slot> inputSlots = List.of(this.getSlot(0));
        final List<Slot> craftingSlots = List.of(this.getSlot(0), this.getSlot(1));
        ServerPlaceRecipe.CraftingMenuAccess<FreezerSolidifyingRecipe> access = new ServerPlaceRecipe.CraftingMenuAccess<FreezerSolidifyingRecipe>(){

            public void fillCraftSlotsStackedContents(StackedItemContents contents) {
                FreezerMenu.this.fillCraftSlotsStackedContents(contents);
            }

            public void clearCraftingContent() {
                craftingSlots.forEach(slot -> slot.set(ItemStack.EMPTY));
            }

            public boolean recipeMatches(RecipeHolder<FreezerSolidifyingRecipe> holder) {
                return ((FreezerSolidifyingRecipe)holder.value()).matches(new SingleRecipeInput(FreezerMenu.this.container.getItem(0)), FreezerMenu.this.level);
            }
        };
        return ServerPlaceRecipe.placeRecipe((ServerPlaceRecipe.CraftingMenuAccess)access, (int)1, (int)1, inputSlots, craftingSlots, (Inventory)inventory, recipeHolder, (boolean)useMax, (boolean)creativeMode);
    }

    public RecipeBookType getRecipeBookType() {
        return Services.PLATFORM.getPlatform().isFabric() ? RecipeBookType.SMOKER : ModRecipeBookTypes.FREEZER.get();
    }
}

