/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mixin;

import com.mrcrayfish.furniture.refurbished.core.ModRecipePropertySets;
import com.mrcrayfish.furniture.refurbished.crafting.CuttingBoardSlicingRecipe;
import com.mrcrayfish.furniture.refurbished.crafting.FreezerSolidifyingRecipe;
import com.mrcrayfish.furniture.refurbished.crafting.MicrowaveHeatingRecipe;
import com.mrcrayfish.furniture.refurbished.crafting.OvenBakingRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipePropertySet;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Shadow
    @Final
    @Mutable
    private static Map<ResourceKey<RecipePropertySet>, RecipeManager.IngredientExtractor> RECIPE_PROPERTY_SETS;

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void afterStaticInit(CallbackInfo ci) {
        LinkedHashMap<ResourceKey<RecipePropertySet>, RecipeManager.IngredientExtractor> copy = new LinkedHashMap<ResourceKey<RecipePropertySet>, RecipeManager.IngredientExtractor>(RECIPE_PROPERTY_SETS);
        copy.put(ModRecipePropertySets.FREEZER_INPUT, recipe -> {
            Optional<Object> optional;
            if (recipe instanceof FreezerSolidifyingRecipe) {
                FreezerSolidifyingRecipe f = (FreezerSolidifyingRecipe)recipe;
                optional = Optional.of(f.getIngredient());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        copy.put(ModRecipePropertySets.MICROWAVE_INPUT, recipe -> {
            Optional<Object> optional;
            if (recipe instanceof MicrowaveHeatingRecipe) {
                MicrowaveHeatingRecipe m = (MicrowaveHeatingRecipe)recipe;
                optional = Optional.of(m.getIngredient());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        copy.put(ModRecipePropertySets.OVEN_INPUT, recipe -> {
            Optional<Object> optional;
            if (recipe instanceof OvenBakingRecipe) {
                OvenBakingRecipe o = (OvenBakingRecipe)recipe;
                optional = Optional.of(o.getIngredient());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        copy.put(ModRecipePropertySets.CUTTING_BOARD_INPUT, recipe -> {
            Optional<Object> optional;
            if (recipe instanceof CuttingBoardSlicingRecipe) {
                CuttingBoardSlicingRecipe o = (CuttingBoardSlicingRecipe)recipe;
                optional = Optional.of(o.input());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        RECIPE_PROPERTY_SETS = Map.copyOf(copy);
    }
}

