/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.tileentity.FarmerTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.corelib.client.RenderUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class FarmerRenderer
extends VillagerRendererBase<FarmerTileentity> {
    public FarmerRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    @Override
    public void render(FarmerTileentity farmer, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 vec) {
        BlockState crop;
        super.render(farmer, partialTicks, matrixStack, buffer, combinedLight, combinedOverlay, vec);
        matrixStack.pushPose();
        Direction direction = Direction.SOUTH;
        if (!farmer.isFakeWorld()) {
            direction = (Direction)farmer.getBlockState().getValue((Property)TraderBlock.FACING);
        }
        if (farmer.getVillagerEntity() != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, -0.25);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.render((LivingEntityRenderState)FarmerRenderer.getVillagerRenderState(villagerRenderer, farmer.getVillagerEntity()), matrixStack, buffer, combinedLight);
            matrixStack.popPose();
        }
        if ((crop = farmer.getCrop()) != null) {
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, 0.125);
            matrixStack.translate(-0.5, 0.0, -0.5);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            matrixStack.translate(0.6111111111111112, 0.0, 0.6111111111111112);
            if (FarmerRenderer.minecraft.level != null) {
                BlockRenderDispatcher dispatcher = minecraft.getBlockRenderer();
                int color = minecraft.getBlockColors().getColor(crop, null, null, 0);
                dispatcher.getModelRenderer();
                ModelBlockRenderer.renderModel((PoseStack.Pose)matrixStack.last(), (MultiBufferSource)buffer, (BlockStateModel)dispatcher.getBlockModel(crop), (float)RenderUtils.getRedFloat(color), (float)RenderUtils.getGreenFloat(color), (float)RenderUtils.getBlueFloat(color), (int)combinedLight, (int)combinedOverlay, (BlockAndTintGetter)FarmerRenderer.minecraft.level, (BlockPos)BlockPos.ZERO, (BlockState)crop);
            }
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }
}

