/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.events;

import de.maxhenkel.easyvillagers.EasyVillagersClientMod;
import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.items.ModItems;
import de.maxhenkel.easyvillagers.net.MessagePickUpVillager;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class VillagerEvents {
    @SubscribeEvent
    public void onClick(PlayerInteractEvent.EntityInteract event) {
        if (!event.getLevel().isClientSide) {
            return;
        }
        if (!(event.getTarget() instanceof Villager)) {
            return;
        }
        if (!((Boolean)EasyVillagersMod.CLIENT_CONFIG.enableRightClickPickup.get()).booleanValue()) {
            return;
        }
        Villager villager = (Villager)event.getTarget();
        Player player = event.getEntity();
        if (!player.isShiftKeyDown()) {
            return;
        }
        if (!VillagerEvents.arePickupConditionsMet(villager)) {
            return;
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessagePickUpVillager(villager.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Villager villager;
        if (!EasyVillagersClientMod.PICKUP_KEY.consumeClick()) {
            return;
        }
        Entity pointedEntity = Minecraft.getInstance().crosshairPickEntity;
        if (!(pointedEntity instanceof Villager) || !VillagerEvents.arePickupConditionsMet(villager = (Villager)pointedEntity)) {
            return;
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessagePickUpVillager(villager.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void pickUp(Villager villager, Player player) {
        if (!VillagerEvents.arePickupConditionsMet(villager)) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.VILLAGER.get());
        VillagerData.applyToItem(stack, villager);
        if (player.getMainHandItem().isEmpty()) {
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            villager.discard();
        } else if (player.getInventory().add(stack)) {
            villager.discard();
        }
    }

    public static boolean arePickupConditionsMet(Villager villager) {
        if (!villager.isAlive()) {
            return false;
        }
        return !villager.isSleeping();
    }
}

