/*
 * Decompiled with CFR 0.152.
 */
package com.zv;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ServerState
extends SavedData {
    public static final String ID = "zombie_variants_server_state";
    public ConcurrentHashMap<BlockPos, Boolean> pyramidLocations = new ConcurrentHashMap();
    public static final Codec<ServerState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PyramidLocation.CODEC.listOf().optionalFieldOf("pyramidLocations", List.of()).forGetter(state -> state.pyramidLocations.entrySet().stream().map(PyramidLocation::fromMapEntry).collect(Collectors.toList()))).apply((Applicative)instance, ServerState::new));
    public static final SavedDataType<ServerState> STATE_TYPE = new SavedDataType("zombie_variants_server_state", ServerState::new, CODEC, DataFixTypes.STATS);

    public static ServerState get(Entity entity) {
        return ServerState.get(entity.getServer());
    }

    public static ServerState get(LevelAccessor world) {
        return ServerState.get(world.getServer());
    }

    public static ServerState get(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.getLevel(Level.OVERWORLD).getDataStorage();
        ServerState serverState = (ServerState)persistentStateManager.computeIfAbsent(STATE_TYPE);
        serverState.setDirty();
        return serverState;
    }

    public ServerState() {
        this.setDirty();
    }

    private ServerState(List<PyramidLocation> pyramidLocations) {
        for (PyramidLocation location : pyramidLocations) {
            this.pyramidLocations.put(location.pos, location.hasPyramid);
        }
        this.setDirty();
    }

    public record PyramidLocation(BlockPos pos, boolean hasPyramid) {
        public static final Codec<PyramidLocation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(PyramidLocation::pos), (App)Codec.BOOL.fieldOf("hasPyramid").forGetter(PyramidLocation::hasPyramid)).apply((Applicative)instance, PyramidLocation::new));

        public static PyramidLocation fromMapEntry(Map.Entry<BlockPos, Boolean> entry) {
            return new PyramidLocation(entry.getKey(), entry.getValue());
        }
    }
}

