/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.handler;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.universalbonemeal.network.ClientboundGrowthParticlesMessage;
import fuzs.universalbonemeal.world.level.block.behavior.BoneMealBehavior;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;

public class UseBoneMealHandler {
    private static final List<AbstractBehaviorData> BONE_MEAL_BEHAVIORS = new ArrayList<AbstractBehaviorData>();
    private static Map<Block, BoneMealBehavior> blockToBehavior;

    public static EventResult onUseBoneMeal(Level level, BlockPos blockPos, BlockState blockState, ItemStack itemStack) {
        BoneMealBehavior boneMealBehavior = UseBoneMealHandler.dissolve().get(blockState.getBlock());
        if (boneMealBehavior != null && boneMealBehavior.isValidBonemealTarget((LevelReader)level, blockPos, blockState)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (boneMealBehavior.isBonemealSuccess(level, level.random, blockPos, blockState)) {
                    boneMealBehavior.performBonemeal(serverLevel, level.random, blockPos, blockState);
                }
                if (itemStack.isStackable()) {
                    itemStack.shrink(1);
                } else if (itemStack.isDamageableItem()) {
                    ItemHelper.hurtAndBreak((ItemStack)itemStack, (int)1, (ServerLevel)serverLevel, null, (Consumer)Consumers.nop());
                }
                if (!(blockState.getBlock() instanceof BonemealableBlock)) {
                    MessageSender.broadcast((PlayerSet)PlayerSet.nearPosition((Vec3i)blockPos, (ServerLevel)serverLevel), (Message)new ClientboundGrowthParticlesMessage(blockPos));
                }
            }
            return EventResult.ALLOW;
        }
        return EventResult.PASS;
    }

    private static Map<Block, BoneMealBehavior> dissolve() {
        Map<Block, BoneMealBehavior> map = blockToBehavior;
        if (map == null) {
            IdentityHashMap<Block, BoneMealBehavior> newMap = new IdentityHashMap<Block, BoneMealBehavior>();
            for (AbstractBehaviorData behavior : BONE_MEAL_BEHAVIORS) {
                if (!behavior.allow()) continue;
                behavior.compile(newMap);
            }
            blockToBehavior = ImmutableMap.copyOf(newMap);
            return blockToBehavior;
        }
        return map;
    }

    public static void invalidate() {
        blockToBehavior = null;
    }

    public static void registerBehavior(Block block, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockBehaviorData(block, factory, config));
    }

    public static void registerBehavior(Set<Block> blocks, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new MultiBlockBehaviorData(blocks, factory, config));
    }

    public static void registerBehavior(TagKey<Block> tag, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockTagBehaviorData(tag, null, factory, config));
    }

    public static void registerBehavior(TagKey<Block> allowedTag, TagKey<Block> disallowedTag, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockTagBehaviorData(allowedTag, disallowedTag, factory, config));
    }

    private static abstract class AbstractBehaviorData {
        final BoneMealBehavior behavior;
        private final BooleanSupplier config;

        public AbstractBehaviorData(Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            this.behavior = factory.get();
            this.config = config;
        }

        public abstract void compile(Map<Block, BoneMealBehavior> var1);

        public boolean allow() {
            return this.config.getAsBoolean();
        }
    }

    private static class BlockBehaviorData
    extends AbstractBehaviorData {
        private final Block block;

        public BlockBehaviorData(Block block, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.block = block;
        }

        @Override
        public void compile(Map<Block, BoneMealBehavior> map) {
            map.put(this.block, this.behavior);
        }
    }

    private static class MultiBlockBehaviorData
    extends AbstractBehaviorData {
        private final Set<Block> targets;

        public MultiBlockBehaviorData(Set<Block> targets, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.targets = targets;
        }

        @Override
        public void compile(Map<Block, BoneMealBehavior> map) {
            for (Block target : this.targets) {
                map.putIfAbsent(target, this.behavior);
            }
        }
    }

    private static class BlockTagBehaviorData
    extends AbstractBehaviorData {
        private final TagKey<Block> allowedTag;
        @Nullable
        private final TagKey<Block> disallowedTag;

        public BlockTagBehaviorData(TagKey<Block> allowedTag, @Nullable TagKey<Block> disallowedTag, Supplier<BoneMealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.allowedTag = allowedTag;
            this.disallowedTag = disallowedTag;
        }

        @Override
        public void compile(Map<Block, BoneMealBehavior> map) {
            for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(this.allowedTag)) {
                if (this.disallowedTag != null && holder.is(this.disallowedTag)) continue;
                map.putIfAbsent((Block)holder.value(), this.behavior);
            }
        }
    }
}

