/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.beb.mixin;

import com.cerbon.beb.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.MissingItemModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemModelResolver.class})
public class ItemModelResolverMixin {
    @Inject(method={"appendItemLayers(Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="INVOKE", target="Ljava/util/function/Function;apply(Ljava/lang/Object;)Ljava/lang/Object;")}, cancellable=true)
    private void appendItemLayers(ItemStackRenderState renderState, ItemStack stack, ItemDisplayContext displayContext, Level level, LivingEntity entity, int seed, CallbackInfo ci) {
        ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        if (!stack.is(Items.ENCHANTED_BOOK) || enchants.isEmpty()) {
            return;
        }
        String enchantId = ((Holder)((Object2IntMap.Entry)enchants.entrySet().iterator().next()).getKey()).getRegisteredName();
        ItemModel itemModel = Services.PLATFORM.getItemModel(ResourceLocation.tryParse((String)enchantId), Minecraft.getInstance().getModelManager());
        if (itemModel != null && !(itemModel instanceof MissingItemModel)) {
            ClientLevel clientLevel;
            itemModel.update(renderState, stack, (ItemModelResolver)this, displayContext, level instanceof ClientLevel ? (clientLevel = (ClientLevel)level) : null, entity, seed);
            ci.cancel();
        }
    }
}

