/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.WirelessChargersClient;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChargerBlock
extends BaseBlock
implements EntityHoldingBlock,
SimpleWaterloggedBlock {
    public final ChargerType type;

    public ChargerBlock(ChargerType type) {
        super(true, BlockProperties.create().mapColor(MapColor.COLOR_GRAY).sound(SoundType.METAL).destroyTime(2.0f).explosionResistance(2.0f));
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.type.modelType.outlineShape.getUnderlying();
    }

    public VoxelShape getCollisionShape(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return this.type.modelType.collisionShape.getUnderlying();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.type.createBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (level.isClientSide) {
            WirelessChargersClient.openChargerScreen((Component)TextComponents.block((Block)this).get(), level, pos);
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        int redstoneMode;
        CompoundTag tag;
        int energy;
        MutableComponent transferRate;
        MutableComponent range = TextComponents.number((int)(this.type.range.get() * 2 + 1)).color(ChatFormatting.GOLD).get();
        if (this.type.canChargeBlocks) {
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.blocks", (Object[])new Object[]{range}).color(ChatFormatting.YELLOW).get());
            transferRate = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.transferRate.get())).color(ChatFormatting.GOLD).string(" " + EnergyFormat.formatUnitPerTick()).color(ChatFormatting.GRAY).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.transfer_rate_blocks", (Object[])new Object[]{transferRate}).color(ChatFormatting.GRAY).get());
        }
        if (this.type.canChargePlayers) {
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.players", (Object[])new Object[]{range}).color(ChatFormatting.YELLOW).get());
            transferRate = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.transferRate.get())).color(ChatFormatting.GOLD).string(" " + EnergyFormat.formatUnitPerTick()).color(ChatFormatting.GRAY).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.transfer_rate_players", (Object[])new Object[]{transferRate}).color(ChatFormatting.GRAY).get());
        }
        int n = energy = (tag = (CompoundTag)stack.get(BaseBlock.TILE_DATA)) == null ? 0 : tag.getIntOr("energy", 0);
        if (energy > 0) {
            MutableComponent energyText = TextComponents.string((String)EnergyFormat.formatEnergy((int)energy)).color(ChatFormatting.GOLD).get();
            MutableComponent capacity = TextComponents.string((String)EnergyFormat.formatEnergy((int)this.type.capacity.get())).color(ChatFormatting.GOLD).string(" " + EnergyFormat.formatUnit()).color(ChatFormatting.GRAY).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.stored_energy", (Object[])new Object[]{energyText, capacity}).color(ChatFormatting.GRAY).get());
        }
        int n2 = redstoneMode = tag == null ? 2 : tag.getIntOr("redstoneMode", 2);
        if (redstoneMode != 2) {
            ChargerBlockEntity.RedstoneMode mode = ChargerBlockEntity.RedstoneMode.fromIndex(redstoneMode);
            MutableComponent value = TextComponents.translation((String)("wirelesschargers.screen.redstone_" + mode.name().toLowerCase(Locale.ROOT))).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"wirelesschargers.charger.info.redstone_mode", (Object[])new Object[]{value}).color(ChatFormatting.GRAY).get());
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return direction != Direction.UP;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ChargerBlockEntity) {
            ((ChargerBlockEntity)entity).setRedstonePowered(level.hasNeighborSignal(pos));
        }
    }
}

