/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.compat.ModCompatibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ChargerBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    private static final int SEARCH_BLOCKS_PER_TICK = 5;
    private static final List<Direction> CAPABILITY_DIRECTIONS;
    public final ChargerType type;
    private int energy;
    private boolean highlightArea;
    private RedstoneMode redstoneMode = RedstoneMode.DISABLED;
    private boolean isRedstonePowered;
    private int blockSearchX;
    private int blockSearchY;
    private int blockSearchZ;
    private final Map<BlockPos, List<Direction>> chargeableBlocks = new LinkedHashMap<BlockPos, List<Direction>>();
    public int renderingTickCount = 0;
    public float renderingRotationSpeed;
    public float renderingRotation;

    public ChargerBlockEntity(ChargerType type, BlockPos pos, BlockState state) {
        super(type.getBlockEntityType(), pos, state);
        this.type = type;
    }

    /*
     * WARNING - void declaration
     */
    public void update() {
        if (this.level.isClientSide) {
            ++this.renderingTickCount;
            if (!this.redstoneMode.canOperate(this.isRedstonePowered)) {
                this.renderingRotationSpeed = Math.max(0.0f, this.renderingRotationSpeed - 0.02f);
                this.renderingRotation += this.renderingRotationSpeed;
                return;
            }
            this.renderingRotationSpeed = Math.min(this.renderingRotationSpeed + 0.02f, this.getEnergyFillPercentage());
            this.renderingRotation += this.renderingRotationSpeed;
        } else {
            Object storage;
            boolean spawnParticles = false;
            if (this.type.canChargeBlocks) {
                ArrayList<Direction> chargeableDirections = new ArrayList<Direction>(CAPABILITY_DIRECTIONS.size());
                for (int i = 0; i < 5; ++i) {
                    BlockEntity entity;
                    BlockPos offset = new BlockPos(this.blockSearchX, this.blockSearchY, this.blockSearchZ);
                    BlockPos blockPos = this.worldPosition.offset((Vec3i)offset);
                    if (!blockPos.equals((Object)this.worldPosition) && (entity = this.level.getBlockEntity(blockPos)) != null && !(entity instanceof ChargerBlockEntity)) {
                        for (Direction direction : CAPABILITY_DIRECTIONS) {
                            storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, blockPos, null, entity, (Object)direction);
                            if (storage == null || !storage.canReceive()) continue;
                            chargeableDirections.add(direction);
                        }
                        if (chargeableDirections.isEmpty()) {
                            this.chargeableBlocks.remove(offset);
                        } else {
                            if (!chargeableDirections.equals(this.chargeableBlocks.get(offset))) {
                                this.chargeableBlocks.put(offset, new ArrayList(chargeableDirections));
                            }
                            chargeableDirections.clear();
                        }
                    }
                    int range = this.type.range.get();
                    ++this.blockSearchX;
                    if (this.blockSearchX <= range) continue;
                    this.blockSearchX = -range;
                    ++this.blockSearchZ;
                    if (this.blockSearchZ <= range) continue;
                    this.blockSearchZ = -range;
                    ++this.blockSearchY;
                    if (this.blockSearchY <= range) continue;
                    this.blockSearchY = -range;
                }
                if (this.energy > 0 && this.redstoneMode.canOperate(this.isRedstonePowered)) {
                    HashSet<BlockPos> toRemove = new HashSet<BlockPos>();
                    for (Map.Entry entry : this.chargeableBlocks.entrySet()) {
                        BlockEntity entity = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)entry.getKey()));
                        if (entity != null && !(entity instanceof ChargerBlockEntity)) {
                            int toTransfer = Math.min(this.energy, this.type.transferRate.get());
                            int transferred = 0;
                            storage = ((List)entry.getValue()).iterator();
                            while (storage.hasNext()) {
                                Direction direction = (Direction)storage.next();
                                IEnergyStorage storage2 = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, (BlockPos)entry.getKey(), null, entity, (Object)direction);
                                if (storage2 != null && storage2.canReceive()) {
                                    if ((transferred += storage2.receiveEnergy(toTransfer - transferred, false)) < toTransfer) continue;
                                    break;
                                }
                                toRemove.add((BlockPos)entry.getKey());
                                break;
                            }
                            if (transferred <= 0) continue;
                            spawnParticles = true;
                            this.energy -= transferred;
                            this.dataChanged();
                            if (this.energy > 0) continue;
                            break;
                        }
                        toRemove.add((BlockPos)entry.getKey());
                    }
                    toRemove.forEach(this.chargeableBlocks::remove);
                }
            }
            if (this.type.canChargePlayers && this.energy > 0 && this.redstoneMode.canOperate(this.isRedstonePowered)) {
                List players = this.level.getEntitiesOfClass(Player.class, this.getOperatingArea());
                block4: for (Player player : players) {
                    int n = Math.min(this.energy, this.type.transferRate.get());
                    IItemHandlerModifiable handler = ModCompatibility.curios.getCuriosStacks(player);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        void var5_13;
                        void max;
                        int transferred;
                        ItemStack stack = handler.getStackInSlot(i);
                        if (stack.isEmpty() || (storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null || !storage.canReceive() || (transferred = storage.receiveEnergy((int)(max = var5_13), false)) <= 0) continue;
                        handler.setStackInSlot(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block4;
                        if ((var5_13 -= transferred) <= 0) continue block4;
                    }
                    Inventory inventory = player.getInventory();
                    for (int i = 0; i < inventory.getContainerSize(); ++i) {
                        void var5_14;
                        void max;
                        int transferred;
                        IEnergyStorage storage3;
                        ItemStack stack = inventory.getItem(i);
                        if (stack.isEmpty() || (storage3 = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null || !storage3.canReceive() || (transferred = storage3.receiveEnergy((int)(max = var5_14), false)) <= 0) continue;
                        inventory.setItem(i, stack);
                        spawnParticles = true;
                        this.energy -= transferred;
                        this.dataChanged();
                        if (this.energy <= 0) break block4;
                        if ((var5_14 -= transferred) <= 0) continue block4;
                    }
                }
            }
            if (spawnParticles && this.level instanceof ServerLevel && this.level.getRandom().nextDouble() <= (double)this.getEnergyFillPercentage()) {
                double x = (double)this.worldPosition.getX() + 0.5 + (double)this.level.getRandom().nextFloat() * 0.8 - 0.4;
                double y = (double)this.worldPosition.getY() + 0.7 + (double)this.level.getRandom().nextFloat() * 0.8 - 0.4;
                double z = (double)this.worldPosition.getZ() + 0.5 + (double)this.level.getRandom().nextFloat() * 0.8 - 0.4;
                ((ServerLevel)this.level).sendParticles((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public float getEnergyFillPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.energy / (float)this.type.capacity.get().intValue()));
    }

    public AABB getOperatingArea() {
        return new AABB(this.worldPosition).inflate((double)this.type.range.get().intValue());
    }

    public void setRedstonePowered(boolean powered) {
        if (this.isRedstonePowered != powered) {
            this.isRedstonePowered = powered;
            this.dataChanged();
        }
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex((this.redstoneMode.index + 1) % RedstoneMode.values().length);
        this.dataChanged();
    }

    public boolean isAreaHighlighted() {
        return this.highlightArea;
    }

    public void toggleHighlightArea() {
        this.highlightArea = !this.highlightArea;
        this.dataChanged();
    }

    protected void writeData(ValueOutput output) {
        output.putInt("energy", this.energy);
        output.putBoolean("highlightArea", this.highlightArea);
        output.putInt("redstoneMode", this.redstoneMode.index);
        output.putBoolean("isRedstonePowered", this.isRedstonePowered);
        if (this.type.canChargeBlocks) {
            output.putInt("blockSearchX", this.blockSearchX);
            output.putInt("blockSearchY", this.blockSearchX);
            output.putInt("blockSearchZ", this.blockSearchX);
            int[] arr = new int[this.chargeableBlocks.size() * 4];
            int index = 0;
            for (Map.Entry<BlockPos, List<Direction>> entry : this.chargeableBlocks.entrySet()) {
                arr[index] = entry.getKey().getX();
                arr[index + 1] = entry.getKey().getY();
                arr[index + 2] = entry.getKey().getZ();
                int sides = entry.getValue().contains(null) ? 1 : 0;
                for (Direction side : entry.getValue()) {
                    sides |= 1 << (side == null ? 0 : side.ordinal() + 1);
                }
                arr[index + 3] = sides;
                index += 4;
            }
            output.putIntArray("chargeableBlocks", arr);
        }
    }

    public void writeItemStackData(ValueOutput output) {
        if (this.energy <= 0 && this.redstoneMode == RedstoneMode.DISABLED) {
            return;
        }
        this.writeData(output);
        output.discard("highlightArea");
        output.discard("isRedstonePowered");
        if (this.type.canChargeBlocks) {
            output.discard("blockSearchX");
            output.discard("blockSearchY");
            output.discard("blockSearchZ");
            output.discard("chargeableBlocks");
        }
    }

    protected void readData(ValueInput input) {
        this.energy = input.getIntOr("energy", 0);
        this.highlightArea = input.getBooleanOr("highlightArea", false);
        this.redstoneMode = RedstoneMode.fromIndex(input.getIntOr("redstoneMode", 0));
        this.isRedstonePowered = input.getBooleanOr("isRedstonePowered", false);
        if (this.type.canChargeBlocks && input.getIntArray("chargeableBlocks").isPresent()) {
            this.blockSearchX = input.getIntOr("blockSearchX", 0);
            this.blockSearchY = input.getIntOr("blockSearchY", 0);
            this.blockSearchZ = input.getIntOr("blockSearchZ", 0);
            this.chargeableBlocks.clear();
            int[] arr = input.getIntArray("chargeableBlocks").orElseGet(() -> new int[0]);
            ArrayList<Direction> directions = new ArrayList<Direction>(CAPABILITY_DIRECTIONS.size());
            for (int i = 0; i < arr.length / 4; ++i) {
                BlockPos pos = new BlockPos(arr[i * 4], arr[i * 4 + 1], arr[i * 4 + 2]);
                int sides = arr[i * 4 + 3];
                for (Direction side : CAPABILITY_DIRECTIONS) {
                    if ((sides >> (side == null ? 0 : side.ordinal() + 1) & 1) != 1) continue;
                    directions.add(side);
                }
                this.chargeableBlocks.put(pos, new ArrayList(directions));
                directions.clear();
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = Math.min(maxReceive, Math.min(this.type.capacity.get() - this.energy, this.type.transferRate.get() * 100));
        if (!simulate) {
            this.energy += received;
            this.dataChanged();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.type.capacity.get();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    static {
        ArrayList<Direction> directions = new ArrayList<Direction>(7);
        directions.add(null);
        directions.addAll(Arrays.asList(Direction.values()));
        CAPABILITY_DIRECTIONS = Collections.unmodifiableList(directions);
    }

    public static enum RedstoneMode {
        HIGH(0),
        LOW(1),
        DISABLED(2);

        public final int index;

        private RedstoneMode(int index) {
            this.index = index;
        }

        public boolean canOperate(boolean isPowered) {
            return this == DISABLED || (isPowered ? this == HIGH : this == LOW);
        }

        public static RedstoneMode fromIndex(int index) {
            for (RedstoneMode mode : RedstoneMode.values()) {
                if (mode.index != index) continue;
                return mode;
            }
            return DISABLED;
        }
    }
}

