/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.WirelessChargersClient;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ChargerRenderer
implements CustomBlockEntityRenderer<ChargerBlockEntity> {
    public void render(ChargerBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        BlockStateModel model = WirelessChargersClient.getRingModel(entity.type);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.05 * Math.sin((double)(((float)entity.renderingTickCount + partialTicks) % 100.0f) / 100.0 * 2.0 * Math.PI), 0.5);
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((entity.renderingRotation + entity.renderingRotationSpeed * partialTicks) / 3.0f, 0.0f, 1.0f, 0.0f));
        poseStack.translate(-0.5, 0.0, -0.5);
        ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(RenderType.solid()), (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)combinedLight, (int)combinedOverlay);
        poseStack.translate(0.0, entity.type.modelType.ringYOffset, 0.0);
        ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(RenderType.solid()), (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)combinedLight, (int)combinedOverlay);
        poseStack.popPose();
        if (entity.isAreaHighlighted()) {
            AABB area = entity.getOperatingArea().move((double)(-entity.getBlockPos().getX()), (double)(-entity.getBlockPos().getY()), (double)(-entity.getBlockPos().getZ())).inflate(0.05);
            Random random = new Random(entity.getBlockPos().hashCode());
            float red = random.nextFloat();
            float green = random.nextFloat();
            float blue = random.nextFloat();
            float alpha = 0.2f;
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)area, (float)red, (float)green, (float)blue, (boolean)true);
            RenderUtils.renderBoxSides((PoseStack)poseStack, (AABB)area, (float)red, (float)green, (float)blue, (float)alpha, (boolean)true);
        }
    }
}

