/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.wirelesschargers.ChargerBlockEntity;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.WirelessChargers;
import java.util.Set;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChargerSpecialModelRenderer
implements SpecialModelRenderer.Unbaked {
    public static final MapCodec<ChargerSpecialModelRenderer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChargerType.CODEC.fieldOf("charger").forGetter(renderer -> renderer.chargerType)).apply((Applicative)instance, ChargerSpecialModelRenderer::new));
    private final ChargerType chargerType;
    private ChargerBlockEntity entity;

    public ChargerSpecialModelRenderer(ChargerType type) {
        this.chargerType = type;
    }

    @Nullable
    public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
        return new SpecialModelRenderer<CompoundTag>(){

            public void render(@Nullable CompoundTag data, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, boolean hasFoil) {
                ChargerBlockEntity entity = ChargerSpecialModelRenderer.this.getEntity();
                entity.readData(TagValueInput.create((ProblemReporter)new ProblemReporter.ScopedCollector(entity.problemPath(), WirelessChargers.LOGGER), (HolderLookup.Provider)CommonUtils.getRegistryAccess(), (CompoundTag)data));
                BlockEntityRenderer renderer = ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)entity);
                renderer.render((BlockEntity)entity, ClientUtils.getPartialTicks(), poseStack, bufferSource, combinedLight, combinedOverlay, Vec3.ZERO);
            }

            public void getExtents(Set<Vector3f> set) {
            }

            @Nullable
            public CompoundTag extractArgument(ItemStack stack) {
                return stack.has(BaseBlock.TILE_DATA) ? (CompoundTag)stack.get(BaseBlock.TILE_DATA) : new CompoundTag();
            }
        };
    }

    private ChargerBlockEntity getEntity() {
        if (this.entity == null) {
            this.entity = this.chargerType.createBlockEntity(BlockPos.ZERO, this.chargerType.getBlock().defaultBlockState());
        }
        return this.entity;
    }

    public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
        return CODEC;
    }
}

