/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.wirelesschargers.ChargerRenderer;
import com.supermartijn642.wirelesschargers.ChargerSpecialModelRenderer;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.screen.ChargerScreen;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class WirelessChargersClient {
    private static final Map<ChargerType, BlockStateModel> RING_MODELS = new EnumMap<ChargerType, BlockStateModel>(ChargerType.class);

    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"wirelesschargers");
        for (ChargerType type : ChargerType.values()) {
            handler.registerCustomBlockEntityRenderer(type::getBlockEntityType, ChargerRenderer::new);
            handler.registerBlockSpecialModelRenderer(type::getBlock, () -> new ChargerSpecialModelRenderer(type));
            handler.registerBlockModelConsumer(type.modelType.ringModel, model -> RING_MODELS.put(type, (BlockStateModel)model));
        }
        handler.registerSpecialModelRenderer("charger", ChargerSpecialModelRenderer.CODEC);
    }

    public static void openChargerScreen(Component title, Level level, BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChargerScreen(title, level, pos)));
    }

    public static BlockStateModel getRingModel(ChargerType type) {
        return RING_MODELS.get((Object)type);
    }
}

