/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.ClientEvents;
import de.maxhenkel.camera.entities.ImageRenderer;
import de.maxhenkel.camera.gui.AlbumInventoryScreen;
import de.maxhenkel.camera.gui.AlbumScreen;
import de.maxhenkel.camera.gui.CameraScreen;
import de.maxhenkel.camera.gui.ImageScreen;
import de.maxhenkel.camera.gui.LecternAlbumScreen;
import de.maxhenkel.camera.gui.ResizeFrameScreen;
import de.maxhenkel.camera.items.render.ImageSpecialRenderer;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="camera", dist={Dist.CLIENT})
@EventBusSubscriber(modid="camera", value={Dist.CLIENT})
public class CameraClientMod {
    public static KeyMapping KEY_NEXT;
    public static KeyMapping KEY_PREVIOUS;

    public CameraClientMod(IEventBus eventBus) {
    }

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientEvents());
        EntityRenderers.register((EntityType)((EntityType)CameraMod.IMAGE_ENTITY_TYPE.get()), ImageRenderer::new);
    }

    @SubscribeEvent
    static void onRegisterScreens(RegisterMenuScreensEvent containers) {
        containers.register((MenuType)CameraMod.ALBUM_INVENTORY_CONTAINER.get(), AlbumInventoryScreen::new);
        containers.register((MenuType)CameraMod.ALBUM_CONTAINER.get(), LecternAlbumScreen::new);
    }

    @SubscribeEvent
    static void registerKeyBinds(RegisterKeyMappingsEvent event) {
        KEY_NEXT = new KeyMapping("key.next_image", 264, "key.categories.misc");
        KEY_PREVIOUS = new KeyMapping("key.previous_image", 265, "key.categories.misc");
        event.register(KEY_NEXT);
        event.register(KEY_PREVIOUS);
    }

    @SubscribeEvent
    static void registerItemModels(RegisterSpecialModelRendererEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"image"), ImageSpecialRenderer.Unbaked.MAP_CODEC);
    }

    public static void openImageScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new ImageScreen(stack));
    }

    public static void openAlbumScreen(List<UUID> images) {
        Minecraft.getInstance().setScreen((Screen)new AlbumScreen(images));
    }

    public static void openResizeFrameScreen(UUID id) {
        Minecraft.getInstance().setScreen((Screen)new ResizeFrameScreen(id));
    }

    public static void openCameraScreen(String currentShader) {
        Minecraft.getInstance().setScreen((Screen)new CameraScreen(currentShader));
    }
}

