/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.serialization.Codec;
import de.maxhenkel.camera.ClientConfig;
import de.maxhenkel.camera.CreativeTabEvents;
import de.maxhenkel.camera.ImageCloningRecipe;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.ServerConfig;
import de.maxhenkel.camera.corelib.CommonRegistry;
import de.maxhenkel.camera.corelib.codec.CodecUtils;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.gui.AlbumContainer;
import de.maxhenkel.camera.gui.AlbumInventoryContainer;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.items.ImageFrameItem;
import de.maxhenkel.camera.items.ImageItem;
import de.maxhenkel.camera.net.MessageAlbumPage;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import de.maxhenkel.camera.net.MessagePartialImage;
import de.maxhenkel.camera.net.MessageRequestImage;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageResizeFrame;
import de.maxhenkel.camera.net.MessageSetShader;
import de.maxhenkel.camera.net.MessageTakeBook;
import de.maxhenkel.camera.net.MessageTakeImage;
import de.maxhenkel.camera.net.MessageUploadCustomImage;
import de.maxhenkel.camera.net.PacketManager;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="camera")
@EventBusSubscriber(modid="camera")
public class CameraMod {
    public static final String MODID = "camera";
    public static final Logger LOGGER = LogManager.getLogger((String)"camera");
    public static PacketManager PACKET_MANAGER;
    private static final DeferredRegister.Items ITEM_REGISTER;
    public static final DeferredHolder<Item, ImageFrameItem> FRAME_ITEM;
    public static final DeferredHolder<Item, CameraItem> CAMERA;
    public static final DeferredHolder<Item, ImageItem> IMAGE;
    public static final DeferredHolder<Item, AlbumItem> ALBUM;
    private static final DeferredRegister<MenuType<?>> MENU_REGISTER;
    public static final DeferredHolder<MenuType<?>, MenuType<AlbumInventoryContainer>> ALBUM_INVENTORY_CONTAINER;
    public static final DeferredHolder<MenuType<?>, MenuType<AlbumContainer>> ALBUM_CONTAINER;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER;
    public static final DeferredHolder<EntityType<?>, EntityType<ImageEntity>> IMAGE_ENTITY_TYPE;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTER;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ImageCloningRecipe>> IMAGE_CLONING_SERIALIZER;
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPE_REGISTER;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<ImageData>> IMAGE_DATA_COMPONENT;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Unit>> ACTIVE_DATA_COMPONENT;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<String>> SHADER_DATA_COMPONENT;
    private static final DeferredRegister<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZER_REGISTER;
    public static final DeferredHolder<EntityDataSerializer<?>, EntityDataSerializer<Optional<UUID>>> UUID_ENTITY_DATA_SERIALIZER;
    public static TagKey<Item> IMAGE_PAPER;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;

    public CameraMod(IEventBus eventBus) {
        eventBus.addListener(CreativeTabEvents::onCreativeModeTabBuildContents);
        SERVER_CONFIG = CommonRegistry.registerConfig(MODID, ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(MODID, ModConfig.Type.CLIENT, ClientConfig.class, true);
        ITEM_REGISTER.register(eventBus);
        MENU_REGISTER.register(eventBus);
        ENTITY_REGISTER.register(eventBus);
        RECIPE_SERIALIZER_REGISTER.register(eventBus);
        DATA_COMPONENT_TYPE_REGISTER.register(eventBus);
        ENTITY_DATA_SERIALIZER_REGISTER.register(eventBus);
        ModSounds.SOUND_REGISTER.register(eventBus);
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        PACKET_MANAGER = new PacketManager();
    }

    private static EntityType<ImageEntity> createImageEntityType() {
        return CommonRegistry.registerEntity(MODID, "image_frame", MobCategory.MISC, ImageEntity.class, builder -> builder.setTrackingRange(256).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).sized(1.0f, 1.0f));
    }

    @SubscribeEvent
    static void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("0");
        CommonRegistry.registerMessage(registrar, MessagePartialImage.class);
        CommonRegistry.registerMessage(registrar, MessageTakeImage.class);
        CommonRegistry.registerMessage(registrar, MessageRequestImage.class);
        CommonRegistry.registerMessage(registrar, MessageImage.class);
        CommonRegistry.registerMessage(registrar, MessageImageUnavailable.class);
        CommonRegistry.registerMessage(registrar, MessageSetShader.class);
        CommonRegistry.registerMessage(registrar, MessageDisableCameraMode.class);
        CommonRegistry.registerMessage(registrar, MessageResizeFrame.class);
        CommonRegistry.registerMessage(registrar, MessageRequestUploadCustomImage.class);
        CommonRegistry.registerMessage(registrar, MessageUploadCustomImage.class);
        CommonRegistry.registerMessage(registrar, MessageAlbumPage.class);
        CommonRegistry.registerMessage(registrar, MessageTakeBook.class);
    }

    static {
        ITEM_REGISTER = DeferredRegister.createItems((String)MODID);
        FRAME_ITEM = ITEM_REGISTER.registerItem("image_frame", ImageFrameItem::new);
        CAMERA = ITEM_REGISTER.registerItem(MODID, CameraItem::new);
        IMAGE = ITEM_REGISTER.registerItem("image", ImageItem::new);
        ALBUM = ITEM_REGISTER.registerItem("album", AlbumItem::new);
        MENU_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)MODID);
        ALBUM_INVENTORY_CONTAINER = MENU_REGISTER.register("album_inventory", () -> IMenuTypeExtension.create((windowId, inv, data) -> new AlbumInventoryContainer(windowId, (Container)inv)));
        ALBUM_CONTAINER = MENU_REGISTER.register("album", () -> IMenuTypeExtension.create((windowId, inv, data) -> new AlbumContainer(windowId)));
        ENTITY_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)MODID);
        IMAGE_ENTITY_TYPE = ENTITY_REGISTER.register("image_frame", CameraMod::createImageEntityType);
        RECIPE_SERIALIZER_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)MODID);
        IMAGE_CLONING_SERIALIZER = RECIPE_SERIALIZER_REGISTER.register("image_cloning", ImageCloningRecipe.ImageCloningSerializer::new);
        DATA_COMPONENT_TYPE_REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)MODID);
        IMAGE_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("image", () -> DataComponentType.builder().persistent(ImageData.CODEC).networkSynchronized(ImageData.STREAM_CODEC).build());
        ACTIVE_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("active", () -> DataComponentType.builder().networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)).build());
        SHADER_DATA_COMPONENT = DATA_COMPONENT_TYPE_REGISTER.register("shader", () -> DataComponentType.builder().persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).build());
        ENTITY_DATA_SERIALIZER_REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, (String)MODID);
        UUID_ENTITY_DATA_SERIALIZER = ENTITY_DATA_SERIALIZER_REGISTER.register("uuid", () -> EntityDataSerializer.forValueType(CodecUtils.optionalStreamCodecByteBuf(UUIDUtil.STREAM_CODEC)));
        IMAGE_PAPER = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"image_paper"));
    }
}

