/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import de.maxhenkel.camera.CameraClientMod;
import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.items.ImageItem;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImageEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> ID = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)((EntityDataSerializer)CameraMod.UUID_ENTITY_DATA_SERIALIZER.get()));
    private static final EntityDataAccessor<Direction> FACING = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Integer> WIDTH = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> HEIGHT = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(ImageEntity.class, (EntityDataSerializer)((EntityDataSerializer)CameraMod.UUID_ENTITY_DATA_SERIALIZER.get()));
    private static final AABB NULL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double THICKNESS = 0.0625;
    private static final int MAX_WIDTH = 8;
    private static final int MAX_HEIGHT = 8;

    public ImageEntity(EntityType type, Level world) {
        super(type, world);
        this.setBoundingBox(NULL_AABB);
    }

    public ImageEntity(Level world) {
        this((EntityType)CameraMod.IMAGE_ENTITY_TYPE.get(), world);
    }

    public ImageEntity(Level world, double x, double y, double z) {
        this((EntityType)CameraMod.IMAGE_ENTITY_TYPE.get(), world);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public void tick() {
        this.updateBoundingBox();
        super.tick();
        this.checkValid();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        if (player.isShiftKeyDown() && this.canModify(player)) {
            if (this.level().isClientSide) {
                CameraClientMod.openResizeFrameScreen(this.getUUID());
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (this.hasImage()) {
            if (heldItem.isEmpty()) {
                ItemStack containedItem = this.removeImage();
                player.setItemInHand(hand, containedItem);
                this.playRemoveSound();
            } else {
                ItemStack image = this.removeImage();
                this.playRemoveSound();
                if (!player.addItem(image)) {
                    this.dropItem(image);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!(heldItem.getItem() instanceof ImageItem)) {
            return InteractionResult.PASS;
        }
        ImageData imageData = ImageData.fromStack(heldItem);
        if (imageData == null) {
            return InteractionResult.PASS;
        }
        ItemStack frameStack = heldItem.split(1);
        this.setItem(frameStack);
        this.setImageUUID(imageData.getId());
        this.playAddSound();
        return InteractionResult.SUCCESS;
    }

    public boolean canModify(Player player) {
        if (!player.getAbilities().mayBuild) {
            return false;
        }
        if (!((Boolean)CameraMod.SERVER_CONFIG.frameOnlyOwnerModify.get()).booleanValue()) {
            return true;
        }
        if (player.isCreative() && player.hasPermissions(1)) {
            return true;
        }
        return this.getOwner().orElse(Util.NIL_UUID).equals(player.getUUID());
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource source, float amount) {
        if (!(source.getDirectEntity() instanceof Player)) {
            return false;
        }
        if (!this.canModify((Player)source.getDirectEntity())) {
            return false;
        }
        if (this.hasImage()) {
            ItemStack image = this.removeImage();
            if (!this.level().isClientSide) {
                this.playRemoveSound();
                this.dropItem(image);
            }
            return true;
        }
        this.removeFrame(source.getEntity());
        return true;
    }

    public boolean isValid() {
        return this.level().noCollision((Entity)this, this.getBoundingBox()) && this.level().getEntitiesOfClass(ImageEntity.class, this.getBoundingBox().contract(this.getFacing().getStepX() == 0 ? 0.125 : 0.0, this.getFacing().getStepY() == 0 ? 0.125 : 0.0, this.getFacing().getStepZ() == 0 ? 0.125 : 0.0), image -> image != this).isEmpty();
    }

    public void checkValid() {
        if (!this.isValid()) {
            this.removeFrame();
        }
    }

    public void onBroken(@Nullable Entity entity) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!serverLevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                return;
            }
        }
        this.dropItem(new ItemStack((ItemLike)CameraMod.FRAME_ITEM.get()));
        if (this.hasImage()) {
            this.dropItem(this.removeImage());
        }
    }

    public void resize(MessageResizeFrame.Direction direction, boolean larger) {
        int amount = larger ? 1 : -1;
        switch (direction) {
            case UP: {
                this.setFrameHeight(this.getFrameHeight() + amount);
                break;
            }
            case DOWN: {
                if (!this.setFrameHeight(this.getFrameHeight() + amount)) break;
                this.setImagePosition(this.blockPosition().relative(Direction.DOWN, amount));
                break;
            }
            case RIGHT: {
                this.setFrameWidth(this.getFrameWidth() + amount);
                break;
            }
            case LEFT: {
                if (!this.setFrameWidth(this.getFrameWidth() + amount)) break;
                this.setImagePosition(this.blockPosition().relative(this.getResizeOffset(), amount));
            }
        }
    }

    private Direction getResizeOffset() {
        switch (this.getFacing()) {
            default: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.EAST;
            }
            case SOUTH: 
        }
        return Direction.WEST;
    }

    @Nullable
    public ItemStack getPickResult() {
        if (this.hasImage()) {
            return this.getItem().copy();
        }
        return new ItemStack((ItemLike)CameraMod.FRAME_ITEM.get());
    }

    private void updateBoundingBox() {
        Direction facing = this.getFacing();
        if (facing.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot((float)facing.get2DDataValue() * 90.0f);
        } else {
            this.setXRot(-90.0f * (float)facing.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.setBoundingBox(this.makeBoundingBox());
    }

    protected AABB makeBoundingBox(Vec3 pos) {
        return this.calculateBoundingBox(this.blockPosition(), this.getFacing(), this.getFrameWidth(), this.getFrameHeight());
    }

    private AABB calculateBoundingBox(BlockPos pos, Direction facing, double width, double height) {
        switch (facing) {
            default: {
                return new AABB((double)pos.getX() + 1.0, (double)pos.getY(), (double)pos.getZ() + 1.0 - 0.0625, (double)pos.getX() - width + 1.0, (double)pos.getY() + height, (double)pos.getZ() + 1.0);
            }
            case SOUTH: {
                return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + width, (double)pos.getY() + height, (double)pos.getZ() + 0.0625);
            }
            case WEST: {
                return new AABB((double)pos.getX() + 1.0 - 0.0625, (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + height, (double)pos.getZ() + width);
            }
            case EAST: 
        }
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ() + 1.0, (double)pos.getX() + 0.0625, (double)pos.getY() + height, (double)pos.getZ() - width + 1.0);
    }

    public BlockPos getCenterPosition() {
        Vec3 center = this.getBoundingBox().getCenter();
        return new BlockPos.MutableBlockPos(center.x, center.y, center.z);
    }

    @Nullable
    public ItemEntity dropItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        BlockPos center = this.getCenterPosition();
        ItemEntity entityitem = new ItemEntity(this.level(), (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, stack);
        entityitem.setDefaultPickUpDelay();
        this.level().addFreshEntity((Entity)entityitem);
        return entityitem;
    }

    public void removeFrame(@Nullable Entity source) {
        Level level;
        if (!this.isRemoved() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.onBroken(source);
            this.kill(serverLevel);
        }
    }

    public void removeFrame() {
        this.removeFrame(null);
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void playPlaceSound() {
        this.level().playSound(null, this.getCenterPosition(), SoundEvents.PAINTING_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void playAddSound() {
        this.level().playSound(null, this.getCenterPosition(), SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void playRemoveSound() {
        this.level().playSound(null, this.getCenterPosition(), SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.entityData.get(OWNER);
    }

    public void setOwner(@Nullable UUID owner) {
        this.entityData.set(OWNER, Optional.ofNullable(owner));
    }

    public Optional<UUID> getImageUUID() {
        return (Optional)this.entityData.get(ID);
    }

    public void setImageUUID(UUID uuid) {
        this.entityData.set(ID, Optional.ofNullable(uuid));
    }

    public int getFrameWidth() {
        return (Integer)this.entityData.get(WIDTH);
    }

    public int getFrameHeight() {
        return (Integer)this.entityData.get(HEIGHT);
    }

    public boolean setFrameWidth(int width) {
        if (width <= 0) {
            width = 1;
        } else if (width > 8) {
            width = 8;
        }
        int oldWidth = this.getFrameWidth();
        this.entityData.set(WIDTH, (Object)width);
        return oldWidth != width;
    }

    public boolean setFrameHeight(int height) {
        if (height <= 0) {
            height = 1;
        } else if (height > 8) {
            height = 8;
        }
        int oldHeight = this.getFrameHeight();
        this.entityData.set(HEIGHT, (Object)height);
        return oldHeight != height;
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.entityData.set(ITEM, (Object)stack);
    }

    public void setImagePosition(BlockPos position) {
        this.snapTo((double)position.getX() + 0.5, position.getY(), (double)position.getZ() + 0.5, this.getYRot(), this.getXRot());
        this.updateBoundingBox();
    }

    public void setFacing(Direction facing) {
        this.entityData.set(FACING, (Object)facing);
        this.updateBoundingBox();
    }

    public Direction getFacing() {
        return (Direction)this.entityData.get(FACING);
    }

    private boolean hasImage() {
        return !this.getItem().isEmpty();
    }

    private ItemStack removeImage() {
        ItemStack item = this.getItem();
        this.setItem(ItemStack.EMPTY);
        this.setImageUUID(null);
        return item;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ID, Optional.empty());
        builder.define(FACING, (Object)Direction.NORTH);
        builder.define(WIDTH, (Object)1);
        builder.define(HEIGHT, (Object)1);
        builder.define(ITEM, (Object)ItemStack.EMPTY);
        builder.define(OWNER, Optional.empty());
    }

    public void addAdditionalSaveData(ValueOutput valueOutput) {
        this.getImageUUID().ifPresent(id -> valueOutput.store("image_id", UUIDUtil.CODEC, id));
        this.getOwner().ifPresent(owner -> valueOutput.store("owner", UUIDUtil.CODEC, owner));
        valueOutput.putInt("facing", this.getFacing().get3DDataValue());
        valueOutput.putInt("width", this.getFrameWidth());
        valueOutput.putInt("height", this.getFrameHeight());
        ItemStack item = this.getItem();
        if (!item.isEmpty()) {
            valueOutput.store("item", ItemStack.CODEC, (Object)item);
        }
    }

    public void readAdditionalSaveData(ValueInput valueInput) {
        valueInput.read("image_id", UUIDUtil.CODEC).ifPresent(this::setImageUUID);
        valueInput.read("owner", UUIDUtil.CODEC).ifPresent(this::setOwner);
        this.setFacing(Direction.from3DDataValue((int)valueInput.getIntOr("facing", 0)));
        this.setFrameWidth(valueInput.getIntOr("width", 0));
        this.setFrameHeight(valueInput.getIntOr("height", 0));
        this.setItem(valueInput.read("item", ItemStack.CODEC).orElse(ItemStack.EMPTY));
        this.updateBoundingBox();
    }
}

