/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.entities.ImageEntityRenderState;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ImageRenderer
extends EntityRenderer<ImageEntity, ImageEntityRenderState> {
    private static final ResourceLocation DEFAULT_IMAGE = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/images/default_image.png");
    private static final ResourceLocation EMPTY_IMAGE = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/images/empty_image.png");
    private static final ResourceLocation FRAME_SIDE = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/images/frame_side.png");
    private static final ResourceLocation FRAME_BACK = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/images/frame_back.png");
    private static final float THICKNESS = 0.0625f;
    public static final UUID DEFAULT_IMAGE_UUID = new UUID(0L, 0L);
    private static Minecraft mc;

    public ImageRenderer(EntityRendererProvider.Context context) {
        super(context);
        mc = Minecraft.getInstance();
    }

    public ImageEntityRenderState createRenderState() {
        return new ImageEntityRenderState();
    }

    public void render(ImageEntityRenderState state, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        ImageRenderer.renderImage(state.imageState, state.facing, state.frameWidth, state.frameHeight, stack, bufferSource, state.light);
        ImageRenderer.renderBoundingBox(state, stack, bufferSource);
        super.render((EntityRenderState)state, stack, bufferSource, packedLight);
    }

    public static void renderImage(ImageEntityRenderState.ImageState imageState, Direction facing, float width, float height, PoseStack matrixStack, MultiBufferSource buffer1, int light) {
        float ratioY;
        float ratioX;
        matrixStack.pushPose();
        ResourceLocation resourceLocation = imageState.resourceLocation();
        float imageRatio = imageState.imageRatio();
        boolean stretch = DEFAULT_IMAGE.equals((Object)resourceLocation);
        matrixStack.translate(-0.5, 0.0, -0.5);
        ImageRenderer.rotate(facing, matrixStack);
        float frameRatio = width / height;
        float ratio = imageRatio / frameRatio;
        if (stretch) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else {
            if (ratio >= 1.0f) {
                ratioY = (1.0f - 1.0f / ratio) / 2.0f;
                ratioX = 0.0f;
            } else {
                ratioX = (1.0f - ratio) / 2.0f;
                ratioY = 0.0f;
            }
            ratioX *= width;
            ratioY *= height;
        }
        VertexConsumer builderFront = buffer1.getBuffer(RenderType.entityCutout((ResourceLocation)resourceLocation));
        ImageRenderer.vertex(builderFront, matrixStack, 0.0f + ratioX, ratioY, 0.0625f, 0.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, ratioY, 0.0625f, 1.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f, 0.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, ratioX, height - ratioY, 0.0625f, 0.0f, 0.0f, light);
        VertexConsumer builderSide = buffer1.getBuffer(RenderType.entityCutout((ResourceLocation)FRAME_SIDE));
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 1.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.9375f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.9375f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 1.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 0.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 0.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 0.0625f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 0.0625f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.0f + ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f - ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 1.0f - ratioX, 0.0625f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.0f + ratioX, 0.0625f, light);
        VertexConsumer builderBack = buffer1.getBuffer(RenderType.entityCutout((ResourceLocation)FRAME_BACK));
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f - ratioY, light);
        matrixStack.popPose();
    }

    public void extractRenderState(ImageEntity image, ImageEntityRenderState state, float partialTicks) {
        super.extractRenderState((Entity)image, (EntityRenderState)state, partialTicks);
        state.imageEntityUUID = image.getUUID();
        state.frameWidth = image.getFrameWidth();
        state.frameHeight = image.getFrameHeight();
        state.facing = image.getFacing();
        state.imageState = ImageRenderer.extractImageState(image.getImageUUID().orElse(DEFAULT_IMAGE_UUID));
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)image.level(), (BlockPos)image.getCenterPosition());
        state.imageBoundingBox = image.getBoundingBox().move(-image.getX(), -image.getY(), -image.getZ());
    }

    public static ImageEntityRenderState.ImageState extractImageState(@Nonnull UUID imageId) {
        float imageRatio;
        ResourceLocation resourceLocation;
        if (DEFAULT_IMAGE_UUID.equals(imageId)) {
            resourceLocation = DEFAULT_IMAGE;
            imageRatio = 1.5f;
        } else {
            ResourceLocation rl = TextureCache.instance().getImage(imageId);
            if (rl != null) {
                resourceLocation = rl;
                NativeImage nativeImage = TextureCache.instance().getNativeImage(imageId);
                imageRatio = (float)nativeImage.getWidth() / (float)nativeImage.getHeight();
            } else {
                resourceLocation = DEFAULT_IMAGE;
                imageRatio = 1.5f;
            }
        }
        return new ImageEntityRenderState.ImageState(imageId, imageRatio, resourceLocation);
    }

    private static void vertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, float u, float v, int light) {
        PoseStack.Pose entry = matrixStack.last();
        Matrix4f matrix4f = entry.pose();
        builder.addVertex(matrix4f, x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(entry, 0.0f, 0.0f, -1.0f);
    }

    private static void renderBoundingBox(ImageEntityRenderState state, PoseStack matrixStack, MultiBufferSource buffer) {
        EntityHitResult entityHitResult;
        HitResult hitResult = ImageRenderer.mc.hitResult;
        if (!(hitResult instanceof EntityHitResult) || !(entityHitResult = (EntityHitResult)hitResult).getEntity().getUUID().equals(state.imageEntityUUID)) {
            return;
        }
        if (ImageRenderer.mc.options.hideGui) {
            return;
        }
        matrixStack.pushPose();
        ShapeRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (AABB)state.imageBoundingBox, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        matrixStack.popPose();
    }

    public static void rotate(Direction facing, PoseStack matrixStack) {
        switch (facing) {
            case NORTH: {
                matrixStack.translate(1.0, 0.0, 1.0);
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                matrixStack.translate(0.0, 0.0, 1.0);
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrixStack.translate(1.0, 0.0, 0.0);
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            }
        }
    }
}

