/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.corelib.FontColorUtils;
import de.maxhenkel.camera.corelib.inventory.ScreenBase;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageSetShader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class CameraScreen
extends ScreenBase<AbstractContainerMenu> {
    private static final ResourceLocation CAMERA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/gui/camera.png");
    private static final int PADDING = 10;
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private int index = 0;
    @Nullable
    private Button upload;

    public CameraScreen(String currentShader) {
        super(CAMERA_TEXTURE, new DummyContainer(), Minecraft.getInstance().player.getInventory(), (Component)Component.translatable((String)"gui.camera.title"));
        this.imageWidth = 248;
        this.imageHeight = 109;
        for (int i = 0; i < Shaders.SHADER_LIST.size(); ++i) {
            String s = Shaders.SHADER_LIST.get(i);
            if (currentShader == null) {
                if (!s.equals("none")) continue;
                this.index = i;
                break;
            }
            if (!s.equals(currentShader)) continue;
            this.index = i;
            break;
        }
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        Button.Builder builder = Button.builder((Component)Component.translatable((String)"button.camera.prev"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = Shaders.SHADER_LIST.size() - 1;
            }
            this.sendShader();
        });
        Objects.requireNonNull(this.font);
        this.addRenderableWidget((GuiEventListener)builder.bounds(this.leftPos + 10, this.topPos + 10 + 9 + 10, 70, 20).build());
        Button.Builder builder2 = Button.builder((Component)Component.translatable((String)"button.camera.next"), button -> {
            ++this.index;
            if (this.index >= Shaders.SHADER_LIST.size()) {
                this.index = 0;
            }
            this.sendShader();
        });
        Objects.requireNonNull(this.font);
        this.addRenderableWidget((GuiEventListener)builder2.bounds(this.leftPos + this.imageWidth - 70 - 10, this.topPos + 10 + 9 + 10, 70, 20).build());
        if (((Boolean)CameraMod.SERVER_CONFIG.allowImageUpload.get()).booleanValue()) {
            this.upload = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.camera.upload"), button -> ImageTools.chooseImage(file -> {
                try {
                    UUID uuid = UUID.randomUUID();
                    BufferedImage image = ImageTools.loadImage(file);
                    ClientImageUploadManager.addImage(uuid, image);
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageRequestUploadCustomImage(uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                catch (IOException e) {
                    this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"message.upload_error", (Object[])new Object[]{e.getMessage()}), true);
                    e.printStackTrace();
                }
                this.minecraft.screen = null;
            })).bounds(this.leftPos + this.imageWidth / 2 - 35, this.topPos + this.imageHeight - 20 - 10, 70, 20).build());
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.upload != null) {
            this.upload.active = !ImageTools.isFileChooserOpen();
        }
    }

    private void sendShader() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageSetShader(Shaders.SHADER_LIST.get(this.index)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        MutableComponent chooseFilter = Component.translatable((String)"gui.camera.choose_filter");
        int chooseFilterWidth = this.font.width((FormattedText)chooseFilter);
        guiGraphics.drawString(this.font, chooseFilter.getVisualOrderText(), this.imageWidth / 2 - chooseFilterWidth / 2, 10, -12566464, false);
        MutableComponent shaderName = Component.translatable((String)("shader." + Shaders.SHADER_LIST.get(this.index)));
        int shaderWidth = this.font.width((FormattedText)shaderName);
        FormattedCharSequence formattedCharSequence = shaderName.getVisualOrderText();
        int n = this.imageWidth / 2 - shaderWidth / 2;
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, formattedCharSequence, n, 10 + 9 + 10 + 10 - 9 / 2, FontColorUtils.WHITE, false);
        MutableComponent uploadImage = Component.translatable((String)"gui.camera.upload_image");
        int uploadImageWidth = this.font.width((FormattedText)uploadImage);
        FormattedCharSequence formattedCharSequence2 = uploadImage.getVisualOrderText();
        int n2 = this.imageWidth / 2 - uploadImageWidth / 2;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, formattedCharSequence2, n2, this.imageHeight - 10 - 20 - 10 - 9, -12566464, false);
    }
}

