/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.platform.NativeImage;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.gui.DummyContainer;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ImageScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    public static final ResourceLocation DEFAULT_IMAGE = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"textures/images/default_image.png");
    @Nullable
    private UUID imageID;

    public ImageScreen(ItemStack image) {
        super((AbstractContainerMenu)new DummyContainer(), Minecraft.getInstance().player.getInventory(), (Component)Component.translatable((String)"gui.image.title"));
        ImageData imageData = ImageData.fromStack(image);
        if (imageData != null) {
            this.imageID = imageData.getId();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBlurredBackground(guiGraphics);
        if (this.imageID == null) {
            return;
        }
        ImageScreen.drawImage(guiGraphics, this.width, this.height, this.imageID);
    }

    public static void drawImage(GuiGraphics guiGraphics, int width, int height, UUID uuid) {
        float hnew;
        float wnew;
        int imageHeight;
        int imageWidth;
        ResourceLocation location = TextureCache.instance().getImage(uuid);
        if (location == null) {
            location = DEFAULT_IMAGE;
            imageWidth = 12;
            imageHeight = 8;
        } else {
            NativeImage image = TextureCache.instance().getNativeImage(uuid);
            imageWidth = image.getWidth();
            imageHeight = image.getHeight();
        }
        float scale = 0.8f;
        float ws = (float)width * scale;
        float hs = (float)height * scale;
        float rs = ws / hs;
        float ri = (float)imageWidth / (float)imageHeight;
        if (rs > ri) {
            wnew = (float)imageWidth * hs / (float)imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = (float)imageHeight * ws / (float)imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, location, (int)(left += (1.0f - scale) * ws / 2.0f), (int)(top += (1.0f - scale) * hs / 2.0f), 0.0f, 0.0f, (int)wnew, (int)hnew, imageWidth, imageHeight, imageWidth, imageHeight);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }

    protected void renderBg(GuiGraphics p_283065_, float p_97788_, int p_97789_, int p_97790_) {
    }
}

