/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.integration.waila;

import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.ImageData;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.Date;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerImageFrame
implements IEntityComponentProvider {
    private static final ResourceLocation OBJECT_NAME_TAG = ResourceLocation.fromNamespaceAndPath((String)"jade", (String)"object_name");
    public static final HUDHandlerImageFrame INSTANCE = new HUDHandlerImageFrame();
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"camera", (String)"image_frame");

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof ImageEntity) {
            ImageEntity image = (ImageEntity)entity;
            iTooltip.remove(OBJECT_NAME_TAG);
            iTooltip.add((Component)image.getDisplayName().copy().withStyle(ChatFormatting.WHITE));
            ImageData imageData = ImageData.fromStack(image.getItem());
            if (imageData == null) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.image_frame_empty"));
                return;
            }
            if (!imageData.getOwner().isEmpty()) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.image_owner", (Object[])new Object[]{String.valueOf(ChatFormatting.DARK_GRAY) + imageData.getOwner()}).withStyle(ChatFormatting.GRAY));
            }
            if (imageData.getTime() > 0L) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.image_time", (Object[])new Object[]{String.valueOf(ChatFormatting.DARK_GRAY) + CameraMod.CLIENT_CONFIG.imageDateFormat.format(new Date(imageData.getTime()))}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

