/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.mixins;

import de.maxhenkel.camera.CameraMod;
import de.maxhenkel.camera.gui.AlbumContainer;
import de.maxhenkel.camera.items.AlbumItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LecternBlockEntity.class})
public abstract class LecternTileEntityMixin
extends BlockEntity {
    @Shadow
    ItemStack book;
    @Shadow
    int page;
    @Shadow
    private int pageCount;
    @Shadow
    @Final
    private Container bookAccess;
    @Shadow
    @Final
    private ContainerData dataAccess;

    public LecternTileEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"hasBook"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasBook(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(!this.book.isEmpty() ? 1 : 0));
    }

    @Inject(method={"resolveBook"}, at={@At(value="HEAD")}, cancellable=true)
    public void resolveBook(ItemStack stack, @Nullable Player player, CallbackInfoReturnable<ItemStack> cir) {
        if (this.level instanceof ServerLevel && stack.getItem() instanceof AlbumItem) {
            cir.setReturnValue((Object)stack);
        }
    }

    @Inject(method={"setBook(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void setBook(ItemStack stack, @Nullable Player player, CallbackInfo info) {
        if (!(stack.getItem() instanceof AlbumItem)) {
            return;
        }
        info.cancel();
        this.book = this.resolveBook(stack, player);
        this.page = 0;
        this.pageCount = this.level != null ? ((AlbumItem)((Object)CameraMod.ALBUM.get())).getImages(this.book).size() : 0;
        this.setChanged();
    }

    @Inject(method={"createMenu"}, at={@At(value="HEAD")}, cancellable=true)
    public void createMenu(int id, Inventory playerInventory, Player player, CallbackInfoReturnable<AbstractContainerMenu> cir) {
        if (!(this.book.getItem() instanceof AlbumItem)) {
            return;
        }
        cir.setReturnValue((Object)new AlbumContainer(id, this.bookAccess, this.dataAccess));
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    public void read(ValueInput valueInput, CallbackInfo ci) {
        if (!(this.book.getItem() instanceof AlbumItem)) {
            return;
        }
        this.pageCount = ((AlbumItem)((Object)CameraMod.ALBUM.get())).getImages(this.book).size();
    }

    @Shadow
    protected abstract ItemStack resolveBook(ItemStack var1, @Nullable Player var2);
}

