/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.crystalnest.soul_fire_d.api.Fire;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;

public class CustomFireBlock
extends BaseFireBlock
implements FireTyped {
    public static final int MAX_AGE = 15;
    public static final IntegerProperty AGE = FireBlock.AGE;
    public static final MapCodec<CustomFireBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("fire_type").forGetter(block -> block.fireType), (App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("base").forGetter(block -> block.base), (App)CustomFireBlock.propertiesCodec()).apply((Applicative)instance, CustomFireBlock::new));
    private final ResourceLocation fireType;
    private final TagKey<Block> base;

    public CustomFireBlock(ResourceLocation fireType, TagKey<Block> base, BlockBehaviour.Properties properties) {
        this(fireType, base, true, properties);
    }

    public CustomFireBlock(ResourceLocation fireType, TagKey<Block> base, boolean addDefaultProperties, BlockBehaviour.Properties properties) {
        super((addDefaultProperties ? CustomFireBlock.addDefaultProperties(properties) : properties).lightLevel(state -> FireManager.light(fireType)), FireManager.getProperty(fireType, Fire::getDamage).floatValue());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.fireType = fireType;
        this.base = base;
    }

    private static BlockBehaviour.Properties addDefaultProperties(BlockBehaviour.Properties properties) {
        return properties.replaceable().noCollission().instabreak().sound(SoundType.WOOL).pushReaction(PushReaction.DESTROY);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull LevelReader level, @NotNull ScheduledTickAccess scheduledTickAccess, @NotNull BlockPos pos, @NotNull Direction direction, @NotNull BlockPos neighborPos, @NotNull BlockState neighborState, @NotNull RandomSource random) {
        return this.canSurvive(state, level, pos) ? this.getStateWithAge(level, pos, (Integer)state.getValue((Property)AGE)) : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return this.canSurvive(level.getBlockState(pos.below()));
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        super.tick(state, level, pos, rand);
        this.scheduleTick((Level)level, pos);
        if (level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            int age = (Integer)state.getValue((Property)AGE);
            if (!state.canSurvive((LevelReader)level, pos) || FireManager.getProperty(this.getFireType(), Fire::canRainDouse).booleanValue() && !level.getBlockState(pos.below()).is(level.dimensionType().infiniburn()) && level.isRaining() && level.isRainingAt(pos) && (double)rand.nextFloat() < 0.2 + (double)age * 0.03) {
                level.removeBlock(pos, false);
            } else if (age < 15 && rand.nextInt(2) == 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
            }
        }
    }

    @NotNull
    public MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    protected boolean canBurn(@NotNull BlockState state) {
        return true;
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState initial, boolean updateFlags) {
        super.onPlace(state, level, pos, initial, updateFlags);
        this.scheduleTick(level, pos);
    }

    @Override
    public ResourceLocation getFireType() {
        return this.fireType;
    }

    public boolean canSurvive(BlockState state) {
        return state.is(this.base);
    }

    protected BlockState getStateWithAge(LevelReader level, BlockPos pos, int age) {
        BlockState state = CustomFireBlock.getState((BlockGetter)level, (BlockPos)pos);
        return state.hasProperty((Property)AGE) ? (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age)) : state;
    }

    protected void scheduleTick(Level level, BlockPos pos) {
        level.scheduleTick(pos, (Block)this, 30 + level.random.nextInt(10));
    }
}

