/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.soul_fire_d.api.block.entity;

import it.crystalnest.soul_fire_d.api.FireManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class CustomCampfireBlockEntity
extends CampfireBlockEntity {
    public CustomCampfireBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static <T extends Recipe<SingleRecipeInput>> void cookTickGeneric(ServerLevel level, BlockPos pos, BlockState state, CampfireBlockEntity campfire, RecipeManager.CachedCheck<SingleRecipeInput, T> check) {
        boolean flag = false;
        for (int i = 0; i < campfire.getItems().size(); ++i) {
            SingleRecipeInput recipe;
            ItemStack result;
            ItemStack ingredient = (ItemStack)campfire.getItems().get(i);
            if (ingredient.isEmpty()) continue;
            flag = true;
            int n = i;
            campfire.cookingProgress[n] = campfire.cookingProgress[n] + 1;
            if (campfire.cookingProgress[n] < campfire.cookingTime[i] || !(result = check.getRecipeFor((RecipeInput)(recipe = new SingleRecipeInput(ingredient)), level).map(holder -> holder.value().assemble((RecipeInput)recipe, (HolderLookup.Provider)level.registryAccess())).orElse(ingredient)).isItemEnabled(level.enabledFeatures())) continue;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)result);
            campfire.getItems().set(i, (Object)ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        }
        if (flag) {
            CustomCampfireBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return (BlockEntityType)FireManager.CUSTOM_CAMPFIRE_ENTITY_TYPE.get();
    }
}

