/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.constant.dataticket;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public final class SerializableDataTicket<D>
extends DataTicket<D> {
    public static final StreamCodec<RegistryFriendlyByteBuf, SerializableDataTicket<?>> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, DataTicket::id, DataTickets::byName);
    private final StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec;

    private SerializableDataTicket(String id, Class<? extends D> objectType, StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec) {
        super(id, objectType);
        this.streamCodec = streamCodec;
    }

    public static <D> SerializableDataTicket<D> create(String id, Class<? extends D> objectType, StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec) {
        return (SerializableDataTicket)IDENTITY_CACHE.computeIfAbsent(Pair.of(objectType, (Object)id), pair -> DataTickets.registerSerializable(new SerializableDataTicket(id, objectType, streamCodec)));
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec() {
        return this.streamCodec;
    }

    public static SerializableDataTicket<Double> ofDouble(ResourceLocation id) {
        return SerializableDataTicket.create(id.toString(), Double.class, ByteBufCodecs.DOUBLE);
    }

    public static SerializableDataTicket<Float> ofFloat(ResourceLocation id) {
        return SerializableDataTicket.create(id.toString(), Float.class, ByteBufCodecs.FLOAT);
    }

    public static SerializableDataTicket<Boolean> ofBoolean(ResourceLocation id) {
        return SerializableDataTicket.create(id.toString(), Boolean.class, ByteBufCodecs.BOOL);
    }

    public static SerializableDataTicket<Integer> ofInt(ResourceLocation id) {
        return SerializableDataTicket.create(id.toString(), Integer.class, ByteBufCodecs.INT);
    }

    public static SerializableDataTicket<String> ofString(ResourceLocation id) {
        return SerializableDataTicket.create(id.toString(), String.class, ByteBufCodecs.STRING_UTF8);
    }

    public static <E extends Enum<E>> SerializableDataTicket<E> ofEnum(ResourceLocation id, final Class<E> enumClass) {
        return SerializableDataTicket.create(id.toString(), enumClass, new StreamCodec<RegistryFriendlyByteBuf, E>(){

            public E decode(RegistryFriendlyByteBuf buf) {
                return Enum.valueOf(enumClass, buf.readUtf());
            }

            public void encode(RegistryFriendlyByteBuf buf, E data) {
                buf.writeUtf(((Enum)data).toString());
            }
        });
    }

    public static SerializableDataTicket<Vec3> ofVec3(ResourceLocation id) {
        return SerializableDataTicket.create(id.toString(), Vec3.class, ByteBufCodecs.VECTOR3F.map(Vec3::new, Vec3::toVector3f));
    }

    public static SerializableDataTicket<BlockPos> ofBlockPos(ResourceLocation id) {
        return SerializableDataTicket.create(id.toString(), BlockPos.class, new StreamCodec<RegistryFriendlyByteBuf, BlockPos>(){

            public BlockPos decode(RegistryFriendlyByteBuf buf) {
                return buf.readBlockPos();
            }

            public void encode(RegistryFriendlyByteBuf buf, BlockPos blockPos) {
                buf.writeBlockPos(blockPos);
            }
        });
    }
}

