/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math.function.generic;

import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.function.MathFunction;

public final class PowFunction
extends MathFunction {
    private final MathValue value;
    private final MathValue power;

    public PowFunction(MathValue ... values) {
        super(values);
        this.value = values[0];
        this.power = values[1];
    }

    @Override
    public String getName() {
        return "math.pow";
    }

    @Override
    public double compute(AnimationState<?> animationState) {
        return Math.pow(this.value.get(animationState), this.power.get(animationState));
    }

    @Override
    public int getMinArgs() {
        return 2;
    }

    @Override
    public MathValue[] getArgs() {
        return new MathValue[]{this.value, this.power};
    }
}

