/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.util.ClientUtil;

public record BlockEntityAnimTriggerPacket(BlockPos pos, Optional<String> controllerName, String animName) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<BlockEntityAnimTriggerPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("blockentity_anim_trigger"));
    public static final StreamCodec<FriendlyByteBuf, BlockEntityAnimTriggerPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BlockEntityAnimTriggerPacket::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), BlockEntityAnimTriggerPacket::controllerName, (StreamCodec)ByteBufCodecs.STRING_UTF8, BlockEntityAnimTriggerPacket::animName, BlockEntityAnimTriggerPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            BlockEntity patt0$temp = ClientUtil.getLevel().getBlockEntity(this.pos);
            if (patt0$temp instanceof GeoBlockEntity) {
                GeoBlockEntity blockEntity = (GeoBlockEntity)patt0$temp;
                blockEntity.triggerAnim(this.controllerName.orElse(null), this.animName);
            }
        });
    }
}

