/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public class GeoItemRenderer<T extends Item>
implements GeoRenderer<T, RenderData, GeoRenderState> {
    protected final GeoRenderLayersContainer<T, RenderData, GeoRenderState> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoItemRenderer(GeoModel<T> model) {
        this(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels(), model);
    }

    public GeoItemRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet, GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    public GeoItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public List<GeoRenderLayer<T, RenderData, GeoRenderState>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoItemRenderer<T> addRenderLayer(GeoRenderLayer<T, RenderData, GeoRenderState> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoItemRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoItemRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, RenderData renderData) {
        return GeoItem.getId(renderData.itemStack);
    }

    @Override
    @ApiStatus.Internal
    public GeoRenderState captureDefaultRenderState(T animatable, RenderData renderData, GeoRenderState renderState, float partialTick) {
        long instanceId = this.getInstanceId(animatable, renderData);
        ItemStack stack = renderData.itemStack;
        renderState.addGeckolibData(DataTickets.ITEM, animatable);
        renderState.addGeckolibData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
        renderState.addGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, instanceId);
        renderState.addGeckolibData(DataTickets.ANIMATABLE_MANAGER, ((GeoAnimatable)animatable).getAnimatableInstanceCache().getManagerForId(instanceId));
        renderState.addGeckolibData(DataTickets.PARTIAL_TICK, Float.valueOf(partialTick));
        renderState.addGeckolibData(DataTickets.RENDER_COLOR, this.getRenderColor(animatable, renderData, partialTick));
        renderState.addGeckolibData(DataTickets.IS_MOVING, false);
        renderState.addGeckolibData(DataTickets.BONE_RESET_TIME, ((GeoAnimatable)animatable).getBoneResetTime());
        renderState.addGeckolibData(DataTickets.ANIMATABLE_CLASS, animatable.getClass());
        renderState.addGeckolibData(DataTickets.ITEM_RENDER_PERSPECTIVE, renderData.renderPerspective);
        renderState.addGeckolibData(DataTickets.IS_ENCHANTED, stack.isEnchanted());
        renderState.addGeckolibData(DataTickets.IS_STACKABLE, stack.isStackable());
        renderState.addGeckolibData(DataTickets.MAX_USE_DURATION, stack.getUseDuration((LivingEntity)ClientUtil.getClientPlayer()));
        renderState.addGeckolibData(DataTickets.MAX_DURABILITY, stack.getMaxDamage());
        renderState.addGeckolibData(DataTickets.REMAINING_DURABILITY, stack.isDamageableItem() ? stack.getMaxDamage() - stack.getDamageValue() : 1);
        renderState.addGeckolibData(DataTickets.PER_BONE_TASKS, new Reference2ObjectOpenHashMap(0));
        return renderState;
    }

    @Override
    public void preRender(GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            this.itemRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        }
    }

    @Override
    public void adjustPositionForRender(GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, boolean isReRender) {
        if (!isReRender) {
            poseStack.translate(0.5f, 0.51f, 0.5f);
        }
    }

    @Override
    public void scaleModelForRender(GeoRenderState renderState, float widthScale, float heightScale, PoseStack poseStack, BakedGeoModel model, boolean isReRender) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, isReRender);
    }

    public void render(GeoRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (renderState.getGeckolibData(DataTickets.ITEM_RENDER_PERSPECTIVE) == ItemDisplayContext.GUI) {
            this.renderInGui(renderState, poseStack, bufferSource);
        } else {
            RenderType renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
            VertexConsumer buffer = renderType == null ? null : ItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)false, (boolean)renderState.getGeckolibData(DataTickets.HAS_GLINT));
            this.defaultRender(renderState, poseStack, bufferSource, renderType, buffer);
        }
    }

    protected void renderInGui(GeoRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource) {
        MultiBufferSource.BufferSource bufferSource2;
        this.setupLightingForGuiRender();
        MultiBufferSource.BufferSource defaultBufferSource = bufferSource instanceof MultiBufferSource.BufferSource ? (bufferSource2 = (MultiBufferSource.BufferSource)bufferSource) : Minecraft.getInstance().levelRenderer.renderBuffers.bufferSource();
        RenderType renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
        VertexConsumer buffer = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)renderState.getGeckolibData(DataTickets.HAS_GLINT));
        poseStack.pushPose();
        this.defaultRender(renderState, poseStack, (MultiBufferSource)defaultBufferSource, renderType, buffer);
        defaultBufferSource.endBatch();
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        poseStack.popPose();
    }

    @Override
    public void actuallyRender(GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (!isReRender) {
            ((GeoAnimatable)renderState.getGeckolibData(DataTickets.ITEM)).getAnimatableInstanceCache().getManagerForId(renderState.getGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID)).setAnimatableData(DataTickets.ITEM_RENDER_PERSPECTIVE, renderState.getGeckolibData(DataTickets.ITEM_RENDER_PERSPECTIVE));
            this.getGeoModel().handleAnimations(this.createAnimationState(renderState));
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
        if (buffer != null) {
            GeoRenderer.super.actuallyRender(renderState, poseStack, model, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
        }
    }

    @Override
    public void doPostRenderCleanup() {
        this.itemRenderTranslations = null;
        this.modelRenderTranslations = null;
    }

    @Override
    public void renderRecursively(GeoRenderState renderState, PoseStack poseStack, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(renderState, poseStack, bone, renderType, bufferSource, buffer, isReRender, packedLight, packedOverlay, renderColor);
    }

    public void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        } else {
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileItemRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, RenderData renderData, GeoRenderState renderState) {
        GeckoLibServices.Client.EVENTS.fireCompileItemRenderState(this, renderState, animatable, renderData);
    }

    @Override
    public boolean firePreRenderEvent(GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
        return GeckoLibServices.Client.EVENTS.fireItemPreRender(this, renderState, poseStack, model, bufferSource);
    }

    @Override
    public void firePostRenderEvent(GeoRenderState renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource) {
        GeckoLibServices.Client.EVENTS.fireItemPostRender(this, renderState, poseStack, model, bufferSource);
    }

    public record RenderData(ItemStack itemStack, ItemStackRenderState vanillaRenderState, ItemDisplayContext renderPerspective, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
    }
}

