/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public class GeckolibItemSpecialRenderer<T extends Item>
implements SpecialModelRenderer<RenderData<T>> {
    public void render(@Nullable RenderData<T> renderData, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasGlint) {
        if (renderData == null) {
            return;
        }
        renderData.renderState.addGeckolibData(DataTickets.HAS_GLINT, hasGlint);
        renderData.renderState.addGeckolibData(DataTickets.PACKED_OVERLAY, packedOverlay);
        renderData.renderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        renderData.renderer.render(renderData.renderState, poseStack, bufferSource);
    }

    public void getExtents(Set<Vector3f> set) {
        set.add(new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public RenderData<T> extractArgument(ItemStack itemStack, ItemStackRenderState renderState, ItemDisplayContext context, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
        T item = this.makeCovariantItem(itemStack.getItem());
        GeoItemRenderer<?> renderer = GeoRenderProvider.of(item).getGeoItemRenderer();
        if (renderer == null) {
            return null;
        }
        return new RenderData<T>(item, this.buildRenderState(item, itemStack, renderer, renderState, context, level, entity), renderer);
    }

    @Deprecated
    @Nullable
    public RenderData<T> extractArgument(ItemStack itemStack) {
        return this.extractArgument(itemStack, new ItemStackRenderState(), ItemDisplayContext.FIXED, null, null);
    }

    private T makeCovariantItem(Item item) {
        return (T)(item instanceof GeoAnimatable ? item : null);
    }

    private GeoRenderState buildRenderState(T animatable, ItemStack itemStack, GeoItemRenderer<T> renderer, ItemStackRenderState renderState, ItemDisplayContext context, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
        return renderer.fillRenderState(animatable, new GeoItemRenderer.RenderData(itemStack, renderState, context, level, entity), new GeoRenderState.Impl(), Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true));
    }

    public record RenderData<T extends Item>(T item, GeoRenderState renderState, GeoItemRenderer<T> renderer) {
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
            return new GeckolibItemSpecialRenderer();
        }

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

