/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;

public abstract class GeoRenderLayer<T extends GeoAnimatable, O, R extends GeoRenderState> {
    protected final GeoRenderer<T, O, R> renderer;

    public GeoRenderLayer(GeoRenderer<T, O, R> renderer) {
        this.renderer = renderer;
    }

    public GeoModel<T> getGeoModel() {
        return this.renderer.getGeoModel();
    }

    public BakedGeoModel getDefaultBakedModel(GeoRenderState renderState) {
        return this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(renderState));
    }

    public GeoRenderer<T, O, R> getRenderer() {
        return this.renderer;
    }

    protected ResourceLocation getTextureResource(R renderState) {
        return this.renderer.getTextureLocation(renderState);
    }

    @ApiStatus.OverrideOnly
    public void addRenderData(T animatable, O relatedObject, R renderState) {
    }

    public void preRender(R renderState, PoseStack poseStack, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
    }

    public void render(R renderState, PoseStack poseStack, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
    }

    public void addPerBoneRender(R renderState, BakedGeoModel model, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
    }
}

