/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.service.GeckoLibClient;
import software.bernie.geckolib.util.RenderUtil;

public abstract class ItemArmorGeoLayer<T extends LivingEntity, O, R extends EntityRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final EquipmentLayerRenderer equipmentRenderer;
    protected final EquipmentAssetManager equipmentAssets;
    protected final Function<SkullBlock.Type, SkullModelBase> skullModels;

    public ItemArmorGeoLayer(GeoRenderer<T, O, R> geoRenderer, EntityRendererProvider.Context context) {
        super(geoRenderer);
        this.equipmentRenderer = context.getEquipmentRenderer();
        this.equipmentAssets = context.getEquipmentAssets();
        this.skullModels = Util.memoize(type -> SkullBlockRenderer.createModel((EntityModelSet)Minecraft.getInstance().getEntityModels(), (SkullBlock.Type)type));
    }

    protected abstract List<RenderData> getRelevantBones(R var1, BakedGeoModel var2);

    @Override
    public void addRenderData(T animatable, O relatedObject, R renderState) {
        EnumMap<EquipmentSlot, ItemStack> equipment = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(EquipmentSlot.class));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            equipment.put(slot, animatable.getItemBySlot(slot));
        }
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, equipment);
        if (animatable instanceof LivingEntity) {
            T livingEntity = animatable;
            if (!((ItemStack)equipment.get(EquipmentSlot.CHEST)).isEmpty()) {
                float partialTick = ((GeoRenderState)renderState).getGeckolibData(DataTickets.PARTIAL_TICK).floatValue();
                ((GeoRenderState)renderState).addGeckolibData(DataTickets.ELYTRA_ROTATION, new Vec3((double)((LivingEntity)livingEntity).elytraAnimationState.getRotX(partialTick), (double)((LivingEntity)livingEntity).elytraAnimationState.getRotY(partialTick), (double)((LivingEntity)livingEntity).elytraAnimationState.getRotZ(partialTick)));
            }
        }
    }

    @Override
    public void addPerBoneRender(R renderState, BakedGeoModel model, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        for (RenderData renderData : this.getRelevantBones(renderState, model)) {
            model.getBone(renderData.boneName).ifPresentOrElse(bone -> this.createPerBoneRender((GeoBone)bone, renderData, consumer, renderState), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(GeoBone bone, RenderData renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer, R renderState) {
        ItemStack stack = this.getEquipmentStack(bone, renderData.slot, renderState);
        if (!stack.isEmpty()) {
            consumer.accept(bone, (renderState2, poseStack, bone2, renderType, bufferSource, packedLight, packedOverlay, renderColor) -> this.renderForBone(renderState2, renderData.slot, renderData.modelPartFactory, stack, poseStack, bone2, renderType, bufferSource, packedLight, packedOverlay, renderColor));
        }
    }

    protected void renderForBone(R renderState, EquipmentSlot slot, Function<HumanoidModel<?>, ModelPart> modelPartFactory, ItemStack equipmentStack, PoseStack poseStack, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, int packedLight, int packedOverlay, int renderColor) {
        BlockItem blockItem;
        if (equipmentStack.isEmpty()) {
            return;
        }
        Item item = equipmentStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            this.renderSkullAsArmor(poseStack, bone, equipmentStack, skullBlock, bufferSource, packedLight);
        } else {
            HumanoidModel<?> model = this.getHumanoidModelForRender(bone, slot, equipmentStack, renderState);
            ModelPart modelPart = modelPartFactory.apply(model);
            if (!modelPart.cubes.isEmpty()) {
                poseStack.pushPose();
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                if (model instanceof GeoArmorRenderer) {
                    GeoArmorRenderer geoArmorRenderer = (GeoArmorRenderer)model;
                    this.prepHumanoidModelForRender(poseStack, bone, modelPart);
                    geoArmorRenderer.applyBoneVisibilityByPart(slot, modelPart, model);
                    geoArmorRenderer.renderToBuffer(poseStack, null, packedLight, packedOverlay, -1);
                } else {
                    Equippable equippable = (Equippable)equipmentStack.get(DataComponents.EQUIPPABLE);
                    if (equippable != null) {
                        equippable.assetId().ifPresent(assetId -> {
                            this.prepHumanoidModelForRender(poseStack, bone, modelPart);
                            this.renderVanillaArmorPiece(poseStack, renderState, bone, slot, equipmentStack, equippable, (ResourceKey<EquipmentAsset>)assetId, model, modelPart, bufferSource, packedLight, packedOverlay);
                        });
                    }
                }
                poseStack.popPose();
            }
        }
    }

    protected ItemStack getEquipmentStack(GeoBone bone, EquipmentSlot slot, R renderState) {
        return ((GeoRenderState)renderState).getGeckolibData(DataTickets.EQUIPMENT_BY_SLOT).getOrDefault(slot, ItemStack.EMPTY);
    }

    protected EquipmentClientInfo.LayerType getEquipmentLayerType(R renderState, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, ResourceKey<EquipmentAsset> assetId) {
        if (slot == EquipmentSlot.LEGS) {
            return EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS;
        }
        if (slot == EquipmentSlot.CHEST && !this.equipmentAssets.get(assetId).getLayers(EquipmentClientInfo.LayerType.WINGS).isEmpty()) {
            return EquipmentClientInfo.LayerType.WINGS;
        }
        return EquipmentClientInfo.LayerType.HUMANOID;
    }

    protected void renderVanillaArmorPiece(PoseStack poseStack, R renderState, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, Equippable equippable, ResourceKey<EquipmentAsset> assetId, HumanoidModel<?> model, ModelPart modelPart, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        EquipmentClientInfo.LayerType layerType = this.getEquipmentLayerType(renderState, bone, slot, armorStack, assetId);
        Model modelToRender = model;
        if (layerType == EquipmentClientInfo.LayerType.WINGS) {
            if (modelPart != model.body) {
                return;
            }
            modelToRender = this.checkForElytraModel(layerType, renderState, bone, poseStack);
        } else {
            this.setVanillaModelPartVisibility(renderState, armorStack, bone, (HumanoidModel<?>)model, modelPart, slot);
        }
        this.equipmentRenderer.renderLayers(layerType, assetId, modelToRender, armorStack, poseStack, bufferSource, packedLight);
    }

    protected Model checkForElytraModel(EquipmentClientInfo.LayerType layerType, R renderState, GeoBone bone, PoseStack poseStack) {
        ElytraModel model = GeckoLibClient.GENERIC_ELYTRA_MODEL.get();
        HumanoidRenderState humanoidRenderState = new HumanoidRenderState();
        Vec3 elytraRotation = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.ELYTRA_ROTATION, Vec3.ZERO);
        humanoidRenderState.isCrouching = ((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_CROUCHING);
        humanoidRenderState.elytraRotX = (float)elytraRotation.x;
        humanoidRenderState.elytraRotY = (float)elytraRotation.y;
        humanoidRenderState.elytraRotZ = (float)elytraRotation.z;
        model.setupAnim(humanoidRenderState);
        poseStack.translate(0.0f, -1.5f, 0.125f);
        return model;
    }

    protected void setVanillaModelPartVisibility(R renderState, ItemStack armorStack, GeoBone bone, HumanoidModel<?> baseModel, ModelPart modelPart, EquipmentSlot slot) {
        baseModel.setAllVisible(false);
        modelPart.visible = true;
    }

    @NotNull
    @ApiStatus.Internal
    protected <S extends HumanoidRenderState> HumanoidModel<?> getHumanoidModelForRender(GeoBone bone, EquipmentSlot slot, ItemStack stack, R renderState) {
        HumanoidRenderState humanoidRenderState1;
        HumanoidRenderState humanoidRenderState = renderState instanceof HumanoidRenderState ? (humanoidRenderState1 = (HumanoidRenderState)renderState) : new HumanoidRenderState();
        EquipmentClientInfo.LayerType layerType = slot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
        HumanoidModel<HumanoidRenderState> defaultModel = slot == EquipmentSlot.LEGS ? GeckoLibClient.GENERIC_INNER_ARMOR_MODEL.get() : GeckoLibClient.GENERIC_OUTER_ARMOR_MODEL.get();
        return GeckoLibServices.Client.ITEM_RENDERING.getArmorModelForItem(humanoidRenderState, stack, slot, layerType, defaultModel);
    }

    protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
        SkullBlock.Type type = skullBlock.getType();
        SkullModelBase model = this.skullModels.apply(type);
        RenderType renderType = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)((ResolvableProfile)stack.get(DataComponents.PROFILE)));
        poseStack.pushPose();
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.scale(1.1875f, 1.1875f, 1.1875f);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (SkullModelBase)model, (RenderType)renderType);
        poseStack.popPose();
    }

    protected void prepHumanoidModelForRender(PoseStack poseStack, GeoBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        ModelPart.Cube armorCube = (ModelPart.Cube)sourcePart.cubes.getFirst();
        double armorBoneSizeX = firstCube.size().x();
        double armorBoneSizeY = firstCube.size().y();
        double armorBoneSizeZ = firstCube.size().z();
        double actualArmorSizeX = Math.abs(armorCube.maxX - armorCube.minX);
        double actualArmorSizeY = Math.abs(armorCube.maxY - armorCube.minY);
        double actualArmorSizeZ = Math.abs(armorCube.maxZ - armorCube.minZ);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.setPos(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.xRot = -bone.getRotX();
        sourcePart.yRot = -bone.getRotY();
        sourcePart.zRot = bone.getRotZ();
        poseStack.scale(scaleX, scaleY, scaleZ);
    }

    public record RenderData(String boneName, EquipmentSlot slot, Function<HumanoidModel<?>, ModelPart> modelPartFactory) {
        public static RenderData head(String boneName) {
            return new RenderData(boneName, EquipmentSlot.HEAD, model -> model.head);
        }

        public static RenderData body(String boneName) {
            return new RenderData(boneName, EquipmentSlot.CHEST, model -> model.body);
        }

        public static RenderData leftArm(String boneName) {
            return new RenderData(boneName, EquipmentSlot.CHEST, model -> model.leftArm);
        }

        public static RenderData rightArm(String boneName) {
            return new RenderData(boneName, EquipmentSlot.CHEST, model -> model.rightArm);
        }

        public static RenderData leftLeg(String boneName) {
            return new RenderData(boneName, EquipmentSlot.LEGS, model -> model.leftLeg);
        }

        public static RenderData rightLeg(String boneName) {
            return new RenderData(boneName, EquipmentSlot.LEGS, model -> model.rightLeg);
        }

        public static RenderData leftFoot(String boneName) {
            return new RenderData(boneName, EquipmentSlot.FEET, model -> model.leftLeg);
        }

        public static RenderData rightFoot(String boneName) {
            return new RenderData(boneName, EquipmentSlot.FEET, model -> model.rightLeg);
        }
    }
}

