/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class TextureLayerGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final ResourceLocation texture;
    protected final Function<ResourceLocation, RenderType> renderType;

    TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer) {
        this(renderer, MissingTextureAtlasSprite.getLocation(), null);
    }

    public TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer, ResourceLocation texture) {
        this(renderer, texture, null);
    }

    public TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer, ResourceLocation texture, Function<ResourceLocation, RenderType> renderType) {
        super(renderer);
        this.texture = texture;
        this.renderType = renderType;
    }

    @Override
    protected ResourceLocation getTextureResource(R renderState) {
        return this.texture;
    }

    protected RenderType getRenderType(R renderState) {
        ResourceLocation texture = this.getTextureResource(renderState);
        if (this.renderType == null) {
            return this.renderer.getRenderType(renderState, texture);
        }
        return this.renderType.apply(texture);
    }

    @Override
    public void render(R renderState, PoseStack poseStack, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        if (buffer == null) {
            return;
        }
        renderType = this.getRenderType(renderState);
        if (renderType != null) {
            this.renderer.reRender(renderState, poseStack, bakedModel, bufferSource, renderType, bufferSource.getBuffer(renderType), packedLight, packedOverlay, renderColor);
        }
    }
}

