/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.InstancedAnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.loading.object.BakedModelFactory;

public final class GeckoLibUtil {
    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();
        return cache != null ? cache : GeckoLibUtil.createInstanceCache(animatable, !(animatable instanceof Entity) && !(animatable instanceof BlockEntity));
    }

    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable, boolean singletonObject) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();
        if (cache != null) {
            return cache;
        }
        return singletonObject ? new SingletonAnimatableInstanceCache(animatable) : new InstancedAnimatableInstanceCache(animatable);
    }

    public static synchronized Animation.LoopType addCustomLoopType(String name, Animation.LoopType loopType) {
        return Animation.LoopType.register(name, loopType);
    }

    public static synchronized EasingType addCustomEasingType(String name, EasingType easingType) {
        return EasingType.register(name, easingType);
    }

    public static synchronized void addCustomBakedModelFactory(String namespace, BakedModelFactory factory) {
        BakedModelFactory.register(namespace, factory);
    }

    public static synchronized <D> SerializableDataTicket<D> addDataTicket(SerializableDataTicket<D> dataTicket) {
        return DataTickets.registerSerializable(dataTicket);
    }

    @ApiStatus.Internal
    public static boolean areComponentsMatchingIgnoringGeckoLibId(PatchedDataComponentMap map1, PatchedDataComponentMap map2) {
        boolean copyOnWrite;
        PatchedDataComponentMap prevMap;
        DataComponentType<Long> stackId = GeckoLibConstants.STACK_ANIMATABLE_ID_COMPONENT.get();
        boolean patched = false;
        if (map1.has(stackId)) {
            prevMap = map1;
            copyOnWrite = prevMap.copyOnWrite;
            map1 = map1.copy();
            map1.remove(stackId);
            map1.copyOnWrite = copyOnWrite;
            patched = true;
        }
        if (map2.has(stackId)) {
            prevMap = map2;
            copyOnWrite = prevMap.copyOnWrite;
            map2 = map2.copy();
            map2.remove(stackId);
            map2.copyOnWrite = copyOnWrite;
            patched = true;
        }
        return patched && Objects.equals(map1, map2);
    }
}

