/*
 * Decompiled with CFR 0.152.
 */
package edivad.edivadlib.setup;

import java.net.URI;
import java.net.URL;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.VersionChecker;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforgespi.language.IModInfo;

public record UpdateChecker(String modId) {
    @SubscribeEvent
    void handlePlayerLoggedInEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        IModInfo modInfo = (IModInfo)ModList.get().getModFileById(this.modId()).getMods().get(0);
        String modName = modInfo.getDisplayName();
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)modInfo);
        VersionChecker.Status versionStatus = result.status();
        if (versionStatus.shouldDraw()) {
            String newVersion = result.target().toString();
            String modUrl = ((URL)modInfo.getModURL().get()).toString();
            MutableComponent message = Component.literal((String)(modName + ": ")).withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.format("A new version (%s) is available to download.", newVersion)).withStyle(style -> style.withColor(ChatFormatting.WHITE).withUnderlined(Boolean.valueOf(true)).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(modUrl)))));
            event.getPlayer().displayClientMessage((Component)message, false);
        }
    }
}

