/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.bendable_cuboids.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zigythebird.bendable_cuboids.impl.RememberingPos;
import com.zigythebird.bendable_cuboids.impl.RepositionableVertex;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Quad {
    public final RepositionableVertex[] vertices = new RepositionableVertex[4];

    public Quad(RememberingPos[] vertices, float u1, float v1, float u2, float v2, boolean flip) {
        this.vertices[0] = new RepositionableVertex(u2, v1, vertices[0]);
        this.vertices[1] = new RepositionableVertex(u1, v1, vertices[1]);
        this.vertices[2] = new RepositionableVertex(u1, v2, vertices[2]);
        this.vertices[3] = new RepositionableVertex(u2, v2, vertices[3]);
        if (flip) {
            int i = vertices.length;
            for (int j = 0; j < i / 2; ++j) {
                RepositionableVertex vertex = this.vertices[j];
                this.vertices[j] = this.vertices[i - 1 - j];
                this.vertices[i - 1 - j] = vertex;
            }
        }
    }

    public void render(PoseStack.Pose matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        Vector3f normal = this.getDirection();
        normal.mul((Matrix3fc)matrices.normal());
        for (int i = 0; i != 4; ++i) {
            RepositionableVertex vertex = this.vertices[i];
            Vector3f vertexPos = vertex.getPos();
            Vector4f pos = new Vector4f(vertexPos.x / 16.0f, vertexPos.y / 16.0f, vertexPos.z / 16.0f, 1.0f);
            pos.mul((Matrix4fc)matrices.pose());
            vertexConsumer.addVertex(pos.x, pos.y, pos.z, color, vertex.getU(), vertex.getV(), overlay, light, normal.x, normal.y, normal.z);
        }
    }

    private Vector3f getDirection() {
        Vector3f buf = new Vector3f((Vector3fc)this.vertices[3].getPos());
        buf.mul(-1.0f);
        Vector3f vecB = new Vector3f((Vector3fc)this.vertices[1].getPos());
        vecB.add((Vector3fc)buf);
        buf = new Vector3f((Vector3fc)this.vertices[2].getPos());
        buf.mul(-1.0f);
        Vector3f vecA = new Vector3f((Vector3fc)this.vertices[0].getPos());
        vecA.add((Vector3fc)buf);
        vecA.cross((Vector3fc)vecB);
        return vecA.normalize().isFinite() ? vecA : Direction.NORTH.step();
    }

    public static void createAndAddQuads(List<Quad> quads, Map<Vector3f, RememberingPos> positions, Vector3f[] edges, float u1, float v1, float u2, float v2, float textureWidth, float textureHeight, boolean mirror) {
        boolean positiveDirection = v2 > v1;
        float totalTexHeight = Mth.abs((float)(v2 - v1));
        Vector3f origin = edges[0];
        Vector3f vecV = new Vector3f((Vector3fc)edges[2]).sub((Vector3fc)origin);
        float vFracScale = v1 == v2 ? 0.0f : 1.0f / (v2 - v1);
        Vector3f vecU = new Vector3f((Vector3fc)edges[1]).sub((Vector3fc)origin);
        float uFracScale = u1 == u2 ? 0.0f : 1.0f / (u2 - u1);
        Vector3f vPos = new Vector3f((Vector3fc)origin);
        Vector3f nextVPos = new Vector3f((Vector3fc)edges[1]);
        Vector3f vStep = new Vector3f();
        float[] quadHeights = null;
        int segmentHeight = 0;
        if (totalTexHeight > 0.0f && totalTexHeight % 3.0f == 0.0f && (segmentHeight = (int)(totalTexHeight / 3.0f)) > 0) {
            quadHeights = new float[2 + segmentHeight];
            quadHeights[0] = segmentHeight;
            Arrays.fill(quadHeights, 1, 1 + segmentHeight, 1.0f);
            quadHeights[1 + segmentHeight] = segmentHeight;
        }
        int layerIndex = 0;
        float localV = v1;
        while (positiveDirection ? localV < v2 : localV > v2) {
            float actual_dv;
            float dv;
            boolean isMiddleSegment = false;
            if (quadHeights != null) {
                if (layerIndex >= quadHeights.length) break;
                float f = dv = positiveDirection ? quadHeights[layerIndex] : -quadHeights[layerIndex];
                if (layerIndex > 0 && layerIndex <= segmentHeight) {
                    isMiddleSegment = true;
                }
                ++layerIndex;
            } else {
                dv = positiveDirection ? 1.0f : -1.0f;
            }
            float localV2 = localV + dv;
            if (quadHeights == null) {
                if (positiveDirection) {
                    if (localV2 > v2) {
                        localV2 = v2;
                    }
                } else if (localV2 < v2) {
                    localV2 = v2;
                }
            }
            if ((actual_dv = localV2 - localV) == 0.0f) break;
            vStep.set((Vector3fc)vecV).mul(actual_dv * vFracScale);
            if (isMiddleSegment && Mth.abs((float)(u2 - u1)) > 1.0f) {
                boolean uPositive = u2 > u1;
                float du = uPositive ? 1.0f : -1.0f;
                Vector3f uScanPosBottom = new Vector3f((Vector3fc)vPos);
                Vector3f uScanPosTop = new Vector3f((Vector3fc)vPos).add((Vector3fc)vStep);
                for (float localU = u2; localU != u1; localU -= du) {
                    float localU2 = localU - du;
                    if (uPositive) {
                        if (localU2 > u2) {
                            localU2 = u2;
                        }
                    } else if (localU2 < u2) {
                        localU2 = u2;
                    }
                    if (localU == localU2) break;
                    float actual_du = localU2 - localU;
                    Vector3f uStep = new Vector3f((Vector3fc)vecU).mul(actual_du * uFracScale);
                    RememberingPos bottomLeft = Quad.getOrCreate(positions, uScanPosBottom);
                    RememberingPos topLeft = Quad.getOrCreate(positions, uScanPosTop);
                    uScanPosBottom.sub((Vector3fc)uStep);
                    uScanPosTop.sub((Vector3fc)uStep);
                    RememberingPos bottomRight = Quad.getOrCreate(positions, uScanPosBottom);
                    RememberingPos topRight = Quad.getOrCreate(positions, uScanPosTop);
                    quads.add(new Quad(new RememberingPos[]{bottomLeft, bottomRight, topRight, topLeft}, localU2 / textureWidth, localV / textureHeight, localU / textureWidth, localV2 / textureHeight, mirror));
                }
                vPos.add((Vector3fc)vStep);
                nextVPos.add((Vector3fc)vStep);
            } else {
                RememberingPos rp3 = Quad.getOrCreate(positions, vPos);
                RememberingPos rp0 = Quad.getOrCreate(positions, nextVPos);
                vPos.add((Vector3fc)vStep);
                nextVPos.add((Vector3fc)vStep);
                RememberingPos rp2 = Quad.getOrCreate(positions, vPos);
                RememberingPos rp1 = Quad.getOrCreate(positions, nextVPos);
                quads.add(new Quad(new RememberingPos[]{rp3, rp0, rp1, rp2}, u1 / textureWidth, localV / textureHeight, u2 / textureWidth, localV2 / textureHeight, mirror));
            }
            localV = localV2;
        }
    }

    public static RememberingPos getOrCreate(Map<Vector3f, RememberingPos> positions, Vector3f pos) {
        return positions.computeIfAbsent(pos, p -> new RememberingPos(new Vector3f((Vector3fc)p)));
    }
}

