/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.bendable_cuboids.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zigythebird.bendable_cuboids.api.BendableCube;
import com.zigythebird.bendable_cuboids.api.SodiumHelper;
import com.zigythebird.bendable_cuboids.impl.BendApplier;
import com.zigythebird.bendable_cuboids.impl.BendUtil;
import com.zigythebird.bendable_cuboids.impl.BendableCuboidData;
import com.zigythebird.bendable_cuboids.impl.Plane;
import com.zigythebird.bendable_cuboids.impl.Quad;
import com.zigythebird.bendable_cuboids.impl.RememberingPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.Cube.class})
public class CubeMixin
implements BendableCube,
SodiumHelper {
    @Shadow
    @Final
    public float minX;
    @Shadow
    @Final
    public float minY;
    @Shadow
    @Final
    public float minZ;
    @Shadow
    @Final
    public float maxX;
    @Shadow
    @Final
    public float maxY;
    @Shadow
    @Final
    public float maxZ;
    @Unique
    private BendableCuboidData bc$data;
    @Unique
    private final Vector3f[] bc$vertices = new Vector3f[8];
    @Unique
    @Nullable
    private Quad[] sides;
    @Unique
    @Nullable
    private RememberingPos[] positions;
    @Unique
    protected float bc$fixX;
    @Unique
    protected float bc$fixY;
    @Unique
    protected float bc$fixZ;
    @Unique
    protected Plane bc$basePlane;
    @Unique
    protected Plane bc$otherPlane;
    @Unique
    protected float bc$fullSize;
    @Unique
    protected Direction bc$direction;
    @Unique
    protected int bc$pivot;
    @Unique
    protected float bc$bend;
    @Unique
    private boolean bc$useSodiumRendering = true;

    @Inject(method={"<init>(IIFFFFFFFFFZFFLjava/util/Set;)V"}, at={@At(value="RETURN")})
    private void constructor(int u, int v, float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirror, float textureWidth, float textureHeight, Set<Direction> visibleFaces, CallbackInfo ci) {
        this.bc$data = new BendableCuboidData(u, v, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirror, textureWidth, textureHeight, visibleFaces);
    }

    @Override
    public void rebuild(@NotNull Direction direction, int point) {
        float size;
        if (this.sides == null || this.positions == null) {
            this.bc$build();
        }
        if (this.bc$direction == direction && this.bc$pivot == point) {
            return;
        }
        this.bc$direction = Objects.requireNonNull(direction);
        this.bc$pivot = point;
        direction = Direction.UP;
        Vector3f pivot = new Vector3f(0.0f, 0.0f, 0.0f);
        if (point >= 0 && (float)point <= (size = direction.step().mul(this.bc$data.sizeX(), this.bc$data.sizeY(), this.bc$data.sizeZ()).length())) {
            pivot = direction.step().mul(size - (float)(point * 2));
            this.bc$vertices[6] = this.bc$vertices[6].sub((Vector3fc)pivot);
        }
        this.bc$basePlane = new Plane(direction.step(), this.bc$vertices[6]);
        this.bc$otherPlane = new Plane(direction.step(), this.bc$vertices[0]);
        this.bc$fullSize = -direction.step().dot((Vector3fc)this.bc$vertices[0]) + direction.step().dot((Vector3fc)this.bc$vertices[6]);
        this.bc$fixX = (this.bc$data.sizeX() + this.minX + this.minX - pivot.x()) / 2.0f;
        this.bc$fixY = (this.bc$data.sizeY() + this.minY + this.minY - pivot.y()) / 2.0f;
        this.bc$fixZ = (this.bc$data.sizeZ() + this.minZ + this.minZ - pivot.z()) / 2.0f;
    }

    @Unique
    private void bc$build() {
        ArrayList<Quad> planes = new ArrayList<Quad>();
        HashMap<Vector3f, RememberingPos> positions = new HashMap<Vector3f, RememberingPos>();
        float pminX = this.minX - this.bc$data.extraX();
        float pminY = this.minY - this.bc$data.extraY();
        float pminZ = this.minZ - this.bc$data.extraZ();
        float pmaxX = this.maxX + this.bc$data.extraX();
        float pmaxY = this.maxY + this.bc$data.extraY();
        float pmaxZ = this.maxZ + this.bc$data.extraZ();
        if (this.bc$data.mirror()) {
            float tmp = pminX;
            pminX = pmaxX;
            pmaxX = tmp;
        }
        this.bc$vertices[0] = new Vector3f(pminX, pminY, pminZ);
        this.bc$vertices[1] = new Vector3f(pmaxX, pminY, pminZ);
        this.bc$vertices[2] = new Vector3f(pmaxX, pmaxY, pminZ);
        this.bc$vertices[3] = new Vector3f(pminX, pmaxY, pminZ);
        this.bc$vertices[4] = new Vector3f(pminX, pminY, pmaxZ);
        this.bc$vertices[5] = new Vector3f(pmaxX, pminY, pmaxZ);
        this.bc$vertices[6] = new Vector3f(pmaxX, pmaxY, pmaxZ);
        this.bc$vertices[7] = new Vector3f(pminX, pmaxY, pmaxZ);
        float j = this.bc$data.u();
        float k = (float)this.bc$data.u() + this.bc$data.sizeZ();
        float l = (float)this.bc$data.u() + this.bc$data.sizeZ() + this.bc$data.sizeX();
        float m = (float)this.bc$data.u() + this.bc$data.sizeZ() + this.bc$data.sizeX() + this.bc$data.sizeX();
        float n = (float)this.bc$data.u() + this.bc$data.sizeZ() + this.bc$data.sizeX() + this.bc$data.sizeZ();
        float o = (float)this.bc$data.u() + this.bc$data.sizeZ() + this.bc$data.sizeX() + this.bc$data.sizeZ() + this.bc$data.sizeX();
        float p = this.bc$data.v();
        float q = (float)this.bc$data.v() + this.bc$data.sizeZ();
        float r = (float)this.bc$data.v() + this.bc$data.sizeZ() + this.bc$data.sizeY();
        float textureWidth = this.bc$data.textureWidth();
        float textureHeight = this.bc$data.textureHeight();
        boolean mirror = this.bc$data.mirror();
        if (this.bc$data.visibleFaces().contains(Direction.DOWN)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{this.bc$vertices[5], this.bc$vertices[4], this.bc$vertices[1]}, k, p, l, q, textureWidth, textureHeight, mirror);
        }
        if (this.bc$data.visibleFaces().contains(Direction.UP)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{this.bc$vertices[2], this.bc$vertices[3], this.bc$vertices[6]}, l, q, m, p, textureWidth, textureHeight, mirror);
        }
        if (this.bc$data.visibleFaces().contains(Direction.WEST)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{this.bc$vertices[0], this.bc$vertices[4], this.bc$vertices[3]}, j, q, k, r, textureWidth, textureHeight, mirror);
        }
        if (this.bc$data.visibleFaces().contains(Direction.NORTH)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{this.bc$vertices[1], this.bc$vertices[0], this.bc$vertices[2]}, k, q, l, r, textureWidth, textureHeight, mirror);
        }
        if (this.bc$data.visibleFaces().contains(Direction.EAST)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{this.bc$vertices[5], this.bc$vertices[1], this.bc$vertices[6]}, l, q, n, r, textureWidth, textureHeight, mirror);
        }
        if (this.bc$data.visibleFaces().contains(Direction.SOUTH)) {
            Quad.createAndAddQuads(planes, positions, new Vector3f[]{this.bc$vertices[4], this.bc$vertices[5], this.bc$vertices[7]}, n, q, o, r, textureWidth, textureHeight, mirror);
        }
        this.sides = planes.toArray(new Quad[0]);
        this.positions = positions.values().toArray(new RememberingPos[0]);
        this.bc$iteratePositions(Function.identity());
    }

    @Override
    public void bc$useSodiumRendering(boolean use) {
        if (!use && this.sides == null) {
            this.bc$build();
        }
        this.bc$useSodiumRendering = use;
    }

    @WrapMethod(method={"compile(Lcom/mojang/blaze3d/vertex/PoseStack$Pose;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V"})
    private void bc$render(PoseStack.Pose pose, VertexConsumer buffer, int packedLight, int packedOverlay, int color, Operation<Void> original) {
        if (this.bc$useSodiumRendering && this.bc$bend == 0.0f || this.sides == null) {
            original.call(new Object[]{pose, buffer, packedLight, packedOverlay, color});
            return;
        }
        for (Quad quad : this.sides) {
            quad.render(pose, buffer, packedLight, packedOverlay, color);
        }
    }

    @Override
    public Matrix4f applyBend(float bendValue) {
        if (Math.abs(bendValue) < 1.0E-4f) {
            bendValue = 0.0f;
        }
        this.bc$bend = bendValue;
        BendApplier bendApplier = BendUtil.getBend(this, bendValue);
        this.bc$iteratePositions(bendApplier.consumer());
        return bendApplier.matrix4f();
    }

    @Override
    public Direction getBendDirection() {
        return this.bc$direction;
    }

    @Override
    public int getBendPivot() {
        return this.bc$pivot;
    }

    @Override
    public float getBendX() {
        return this.bc$fixX;
    }

    @Override
    public float getBendY() {
        return this.bc$fixY;
    }

    @Override
    public float getBendZ() {
        return this.bc$fixZ;
    }

    @Override
    public Plane getBasePlane() {
        return this.bc$basePlane;
    }

    @Override
    public Plane getOtherPlane() {
        return this.bc$otherPlane;
    }

    @Override
    public float bendHeight() {
        return this.bc$fullSize;
    }

    @Unique
    public void bc$iteratePositions(Function<Vector3f, Vector3f> function) {
        if (this.positions == null) {
            return;
        }
        for (RememberingPos pos : this.positions) {
            pos.setPos(function.apply(pos.getOriginalPos()));
        }
    }

    @Override
    public float getBend() {
        return this.bc$bend;
    }
}

