/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.bendable_cuboids.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zigythebird.bendable_cuboids.BendableCuboidsMod;
import com.zigythebird.bendable_cuboids.api.BendableCube;
import com.zigythebird.bendable_cuboids.api.BendableModelPart;
import com.zigythebird.bendable_cuboids.api.SodiumHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public class ModelPartMixin
implements BendableModelPart,
SodiumHelper {
    @Shadow
    @Final
    public List<ModelPart.Cube> cubes;
    @Shadow
    @Final
    public Map<String, ModelPart> children;

    @Override
    @Nullable
    public BendableCube bc$getCuboid(int index) {
        if (index >= this.cubes.size() || index < 0) {
            return null;
        }
        return (BendableCube)this.cubes.get(index);
    }

    @Override
    public void bc$useSodiumRendering(boolean use) {
        for (ModelPart.Cube cube : this.cubes) {
            if (!(cube instanceof SodiumHelper)) continue;
            SodiumHelper helper = (SodiumHelper)cube;
            helper.bc$useSodiumRendering(use);
        }
        for (ModelPart child : this.children.values()) {
            child.bc$useSodiumRendering(use);
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V"}, at={@At(value="HEAD")})
    private void bc$captureModelPart(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color, CallbackInfo ci) {
        BendableCuboidsMod.currentModelPart = (ModelPart)this;
    }

    @Inject(method={"copyFrom(Lnet/minecraft/client/model/geom/ModelPart;)V"}, at={@At(value="RETURN")})
    private void copyTransformExtended(ModelPart part, CallbackInfo ci) {
        Iterator otherIterator = part.cubes.iterator();
        Iterator<ModelPart.Cube> myIterator = this.cubes.iterator();
        while (otherIterator.hasNext() && myIterator.hasNext()) {
            BendableCube myCube = (BendableCube)myIterator.next();
            BendableCube otherCube = (BendableCube)otherIterator.next();
            myCube.bc$copyState(otherCube);
        }
    }
}

