/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;

public class CommandBlockProvider
implements StreamServerDataProvider<BlockAccessor, String> {
    public static final CommandBlockProvider INSTANCE = new CommandBlockProvider();

    @Override
    @Nullable
    public String streamData(BlockAccessor accessor) {
        if (!accessor.getPlayer().canUseGameMasterBlocks()) {
            return null;
        }
        Object command = ((CommandBlockEntity)accessor.getBlockEntity()).getCommandBlock().getCommand();
        if (((String)command).length() > 40) {
            command = ((String)command).substring(0, 37) + "...";
        }
        return command;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, String> streamCodec() {
        return ByteBufCodecs.STRING_UTF8.cast();
    }

    @Override
    public boolean shouldRequestData(BlockAccessor accessor) {
        return accessor.getPlayer().canUseGameMasterBlocks();
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_COMMAND_BLOCK;
    }

    public static class Client
    implements IBlockComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            String command = INSTANCE.decodeFromData(accessor).orElse("");
            if (command.isBlank()) {
                return;
            }
            tooltip.add((Component)Component.literal((String)("> " + command)));
        }

        @Override
        public ResourceLocation getUid() {
            return JadeIds.MC_COMMAND_BLOCK;
        }
    }
}

