/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.IDisplayHelper;

public class EnergyView {
    public String current;
    public String max;
    public float ratio;
    @Nullable
    public Component overrideText;

    @Nullable
    public static EnergyView read(Data data, String unit) {
        if (data.capacity <= 0L) {
            return null;
        }
        EnergyView energyView = new EnergyView();
        energyView.current = IDisplayHelper.get().humanReadableNumber(data.current, unit, false);
        energyView.max = IDisplayHelper.get().humanReadableNumber(data.capacity, unit, false);
        energyView.ratio = (float)data.current / (float)data.capacity;
        return energyView;
    }

    public record Data(long current, long capacity) {
        public static final StreamCodec<ByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.LONG, Data::current, (StreamCodec)ByteBufCodecs.LONG, Data::capacity, Data::new);
    }
}

