/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetTooltipHolder;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import snownee.jade.api.JadeIds;
import snownee.jade.gui.config.FixedTooltipPositioner;
import snownee.jade.gui.config.OptionsList;

public class OptionsNav
extends ObjectSelectionList<Entry> {
    private static final ResourceLocation NAVBAR_BACKGROUND = JadeIds.JADE("navbar_background");
    private static final ResourceLocation INWORLD_NAVBAR_BACKGROUND = JadeIds.JADE("inworld_navbar_background");
    private final OptionsList options;
    private int current;

    public OptionsNav(OptionsList options, int width, int height, int top, int itemHeight) {
        super(Minecraft.getInstance(), width, height, top, itemHeight);
        this.options = options;
    }

    protected void renderListItems(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderListItems(guiGraphics, i, j, f);
        if (this.children().isEmpty()) {
            return;
        }
        Entry focused = (Entry)this.getFocused();
        if (focused != null && this.minecraft.getLastInputType().isKeyboard()) {
            this.current = this.children().indexOf((Object)focused);
        }
        float top = (float)(this.getY() + 4) - (float)this.scrollAmount() + (float)(this.current * this.itemHeight) + (float)this.headerHeight;
        int left = this.getRowLeft() + 2;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(0.0f, top);
        guiGraphics.fill(left, 0, left + 2, this.itemHeight - 4, -1);
        guiGraphics.pose().popMatrix();
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
        ResourceLocation resourceLocation = this.minecraft.level == null ? NAVBAR_BACKGROUND : INWORLD_NAVBAR_BACKGROUND;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, resourceLocation, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
    }

    protected void renderSelection(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
    }

    public void addEntry(OptionsList.Title entry) {
        super.addEntry((AbstractSelectionList.Entry)new Entry(this, entry));
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int scrollBarX() {
        return this.getRowLeft() + this.getRowWidth() - 8;
    }

    public void refresh() {
        this.clearEntries();
        if (this.options.children().size() <= 1) {
            return;
        }
        for (OptionsList.Entry child : this.options.children()) {
            if (!(child instanceof OptionsList.Title)) continue;
            OptionsList.Title titleEntry = (OptionsList.Title)child;
            this.addEntry(titleEntry);
        }
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        FocusNavigationEvent.ArrowNavigation nav;
        if (!this.isFocused() && event instanceof FocusNavigationEvent.ArrowNavigation && (nav = (FocusNavigationEvent.ArrowNavigation)event).direction() == ScreenDirection.LEFT) {
            for (Entry entry : this.children()) {
                if (entry.title != this.options.currentTitle) continue;
                return ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{this});
            }
        }
        return super.nextFocusPath(event);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        AbstractSelectionList.Entry entry;
        super.setFocused(listener);
        if (this.minecraft.getLastInputType().isKeyboard() && (entry = this.getFocused()) instanceof Entry) {
            Entry entry2 = (Entry)entry;
            this.options.showOnTop(entry2.title);
        }
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final OptionsList.Title title;
        private final OptionsNav parent;
        @Nullable
        private WidgetTooltipHolder tooltip;

        public Entry(OptionsNav parent, OptionsList.Title title) {
            this.parent = parent;
            this.title = title;
            this.refreshTooltip();
        }

        protected void refreshTooltip() {
            if (10 + this.title.getTextWidth() > this.parent.getRowWidth()) {
                this.tooltip = new WidgetTooltipHolder(){

                    public ClientTooltipPositioner createTooltipPositioner(ScreenRectangle screenRectangle, boolean bl, boolean bl2) {
                        int n = screenRectangle.left() + 10;
                        int n2 = screenRectangle.top() + screenRectangle.height() / 2;
                        Objects.requireNonNull(title.client.font);
                        return new FixedTooltipPositioner((Vector2ic)new Vector2i(n, n2 - 9 / 2));
                    }
                };
                this.tooltip.set(Tooltip.create((Component)this.title.getTitle()));
            } else {
                this.tooltip = null;
            }
        }

        public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            Font font = this.title.client.font;
            String string = this.title.getTitle().getString();
            int n = rowTop + height / 2;
            Objects.requireNonNull(this.title.client.font);
            guiGraphics.drawString(font, string, rowLeft + 10, n - 9 / 2, -1);
            if (this.isFocused() && this.parent.minecraft.getLastInputType().isKeyboard()) {
                int color = -5592406;
                int left = rowLeft + 2;
                int right = rowLeft + width - 2;
                int bottom = rowTop + height;
                guiGraphics.fill(left, rowTop, right, rowTop + 1, color);
                guiGraphics.fill(left, bottom, right, bottom - 1, color);
                guiGraphics.fill(left, rowTop, left + 1, bottom, color);
                guiGraphics.fill(right, rowTop, right - 1, bottom, color);
            } else if (this.parent.options.currentTitle == this.title) {
                if (!this.parent.isMouseOver(mouseX, mouseY)) {
                    this.parent.ensureVisible((AbstractSelectionList.Entry)this);
                }
                this.parent.current = index;
            }
            if (this.tooltip != null) {
                this.tooltip.refreshTooltipForNextRenderPass(guiGraphics, mouseX, mouseY, this.isMouseOver(mouseX, mouseY), this.isFocused(), new ScreenRectangle(rowLeft, rowTop, width, height));
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPress();
            }
            return true;
        }

        public boolean keyPressed(int i, int j, int k) {
            if (CommonInputs.selected((int)i)) {
                this.onPress();
                return true;
            }
            return false;
        }

        public Component getNarration() {
            return this.title.narration;
        }

        public void onPress() {
            this.parent.playDownSound(Minecraft.getInstance().getSoundManager());
            this.parent.options.showOnTop(this.title);
        }

        public OptionsList.Title getTitle() {
            return this.title;
        }
    }
}

