/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.Orientation;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.impl.ui.ProgressOverlayElement;
import snownee.jade.overlay.DisplayHelper;

public class SpriteElement
extends ProgressOverlayElement {
    private final RenderPipeline renderPipeline;
    private final ResourceLocation sprite;
    @Nullable
    public Orientation tiledOrientation;
    private final int oWidth;
    private final int oHeight;
    private int color = -1;

    public SpriteElement(ResourceLocation sprite, int width, int height) {
        this(RenderPipelines.GUI_TEXTURED, sprite, width, height);
    }

    public SpriteElement(RenderPipeline renderPipeline, ResourceLocation sprite, int width, int height) {
        this.renderPipeline = renderPipeline;
        this.sprite = sprite;
        this.oWidth = this.width = width;
        this.oHeight = this.height = height;
    }

    @Override
    @Nullable
    public Component getNarration() {
        return null;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.tiledOrientation != null) {
            float tileAxisStep;
            GuiSpriteManager guiSprites = Minecraft.getInstance().getGuiSprites();
            TextureAtlasSprite textureAtlasSprite = guiSprites.getSprite(IThemeHelper.get().theme().mapSprite(this.sprite));
            Rect2f rect = this.floatingRect == null ? Rect2f.of(this) : this.floatingRect.copy();
            float axisLength = this.tiledOrientation.getAxisLength(rect);
            float axisPosition = this.tiledOrientation.getAxisPosition(rect);
            float crossAxisLength = this.tiledOrientation.getCrossAxisLength(rect);
            float crossAxisPosition = this.tiledOrientation.getCrossAxisPosition(rect);
            float f = tileAxisStep = this.tiledOrientation == Orientation.HORIZONTAL ? (float)this.oWidth : (float)this.oHeight;
            for (float tileAxisStart = 0.0f; tileAxisStart < axisLength; tileAxisStart += tileAxisStep) {
                float tileAxisEnd = Math.min(tileAxisStart + tileAxisStep, axisLength);
                float tileSize = tileAxisEnd - tileAxisStart;
                this.tiledOrientation.setPosition(rect, axisPosition + tileAxisStart, crossAxisPosition);
                this.tiledOrientation.setSize(rect, tileSize, crossAxisLength);
                float tileWidth = this.oWidth;
                float tileHeight = this.oHeight;
                if (this.tiledOrientation == Orientation.HORIZONTAL) {
                    tileWidth = tileSize;
                } else {
                    tileHeight = tileSize;
                }
                DisplayHelper.INSTANCE.blitSprite(graphics, this.renderPipeline, textureAtlasSprite, this.oWidth, this.oHeight, 0.0f, 0.0f, tileWidth, tileHeight, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), this.color);
            }
            return;
        }
        if (this.floatingRect == null) {
            IDisplayHelper.get().blitSprite(graphics, this.renderPipeline, this.sprite, this.oWidth, this.oHeight, 0, 0, this.getX(), this.getY(), this.width, this.height, this.color);
        } else {
            DisplayHelper.INSTANCE.blitSprite(graphics, this.renderPipeline, this.sprite, this.oWidth, this.oHeight, 0, 0, this.floatingRect.getX(), this.floatingRect.getY(), this.floatingRect.getWidth(), this.floatingRect.getHeight(), this.color);
        }
        if (IWailaConfig.get().general().isDebug() && this.floatingRect != null) {
            DisplayHelper.INSTANCE.drawBorder(graphics, new ScreenRectangle((int)this.floatingRect.getX(), (int)this.floatingRect.getY(), (int)this.floatingRect.getWidth(), (int)this.floatingRect.getHeight()), 1, -16733526, true);
        }
    }

    @Override
    public boolean canUseFloatingRect() {
        GuiSpriteManager guiSprites = Minecraft.getInstance().getGuiSprites();
        TextureAtlasSprite textureAtlasSprite = guiSprites.getSprite(this.sprite);
        GuiSpriteScaling scaling = guiSprites.getSpriteScaling(textureAtlasSprite);
        return scaling instanceof GuiSpriteScaling.Stretch;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

