/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.i18n.MavenVersionTranslator;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.TranslatableEnum;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.TraceableException;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeServerCommand;
import snownee.jade.impl.lookup.WrappedHierarchyLookup;
import snownee.jade.mixin.AbstractHorseAccess;
import snownee.jade.network.ClientHandshakePacket;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerHandshakePacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeForgeUtils;
import snownee.jade.util.UsernameCache;
import snownee.jade.util.WailaExceptionHandler;

@Mod(value="jade")
public final class CommonProxy {
    @Nullable
    public static String getLastKnownUsername(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Optional optional = SkullBlockEntity.fetchGameProfile((UUID)uuid).getNow(Optional.empty());
        if (optional.isPresent()) {
            return ((GameProfile)optional.get()).getName();
        }
        return UsernameCache.getLastKnownUsername(uuid);
    }

    public static File getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static boolean isCorrectToolForDrops(BlockState state, Player player, Level level, BlockPos pos) {
        return EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)level, (BlockPos)pos);
    }

    public static String getModIdFromItem(ItemStack stack) {
        Holder holder;
        PotionContents potionContents;
        String namespace;
        ResourceLocation id;
        String modid;
        CustomModelData modelData;
        if (CommonProxy.isPhysicallyClient() && !CustomModelData.EMPTY.equals((Object)(modelData = (CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)CustomModelData.EMPTY)))) {
            for (String string : modelData.strings()) {
                if (!string.startsWith("namespace:")) continue;
                return string.substring(10);
            }
        }
        if (stack.has(DataComponents.STORED_ENCHANTMENTS)) {
            ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
            modid = null;
            for (Holder enchantmentHolder : enchantments.keySet()) {
                id = enchantmentHolder.unwrapKey().map(ResourceKey::location).orElse(null);
                if (id == null) continue;
                namespace = id.getNamespace();
                if (modid == null) {
                    modid = namespace;
                    continue;
                }
                if (modid.equals(namespace)) continue;
                modid = null;
                break;
            }
            if (modid != null) {
                return modid;
            }
        }
        if ((potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).hasEffects()) {
            modid = null;
            for (MobEffectInstance effect : potionContents.getAllEffects()) {
                id = effect.getEffect().unwrapKey().map(ResourceKey::location).orElse(null);
                if (id == null) continue;
                namespace = id.getNamespace();
                if (modid == null) {
                    modid = namespace;
                    continue;
                }
                if (modid.equals(namespace)) continue;
                modid = null;
                break;
            }
            if (modid != null) {
                return modid;
            }
        }
        if (stack.is(Items.PAINTING) && (holder = (Holder)stack.get(DataComponents.PAINTING_VARIANT)) != null) {
            return holder.unwrapKey().map(ResourceKey::location).map(ResourceLocation::getNamespace).orElse("minecraft");
        }
        RegistryAccess.Frozen registries = RegistryAccess.EMPTY;
        if (CommonProxy.isPhysicallyClient() && Minecraft.getInstance().level != null) {
            registries = Minecraft.getInstance().level.registryAccess();
        }
        return stack.getItem().getCreatorModId((HolderLookup.Provider)registries, stack);
    }

    public static boolean isPhysicallyClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static ItemCollector<?> createItemCollector(Accessor<?> accessor, Cache<Object, ItemCollector<?>> containerCache) {
        Container container;
        Object target = accessor.getTarget();
        if (target instanceof Player) {
            return ItemCollector.EMPTY;
        }
        if (target instanceof AbstractHorseAccess) {
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(o -> {
                if (o instanceof AbstractHorseAccess) {
                    AbstractHorseAccess horse = (AbstractHorseAccess)((Object)o);
                    return horse.getInventory();
                }
                return null;
            }, 2));
        }
        if (!(target instanceof ChestBlockEntity)) {
            try {
                IItemHandler storage = CommonProxy.findItemHandler(accessor);
                if (storage != null) {
                    return (ItemCollector)containerCache.get((Object)storage, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler(storage, 0)));
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        if ((container = CommonProxy.findContainer(accessor)) != null) {
            if (container instanceof ChestBlockEntity) {
                return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(a -> {
                    Object patt0$temp = a.getTarget();
                    if (patt0$temp instanceof ChestBlockEntity) {
                        ChestBlock chestBlock;
                        Container compound;
                        ChestBlockEntity be = (ChestBlockEntity)patt0$temp;
                        Block patt1$temp = be.getBlockState().getBlock();
                        if (patt1$temp instanceof ChestBlock && (compound = ChestBlock.getContainer((ChestBlock)(chestBlock = (ChestBlock)patt1$temp), (BlockState)be.getBlockState(), (Level)Objects.requireNonNull(be.getLevel()), (BlockPos)be.getBlockPos(), (boolean)false)) != null) {
                            return compound;
                        }
                        return be;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> containerGroup(Container container, Accessor<?> accessor) {
        return CommonProxy.containerGroup(container, accessor, CommonProxy::findContainer);
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> containerGroup(Container container, Accessor<?> accessor, Function<Accessor<?>, Container> containerFinder) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get((Object)container, () -> new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(containerFinder, 0)))).update(accessor);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> storageGroup(Object storage, Accessor<?> accessor) {
        return CommonProxy.storageGroup(storage, accessor, CommonProxy::findItemHandler);
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> storageGroup(Object storage, Accessor<?> accessor, Function<Accessor<?>, Object> storageFinder) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get(storage, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler((IItemHandler)storage, 0, storageFinder)))).update(accessor);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static IItemHandler findItemHandler(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return (IItemHandler)accessor.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null);
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor entityAccessor = (EntityAccessor)accessor;
            return (IItemHandler)entityAccessor.getEntity().getCapability(Capabilities.ItemHandler.ENTITY);
        }
        return null;
    }

    @Nullable
    public static Container findContainer(Accessor<?> accessor) {
        BlockAccessor blockAccessor;
        Block block;
        Object target = accessor.getTarget();
        if (target == null && accessor instanceof BlockAccessor && (block = (blockAccessor = (BlockAccessor)accessor).getBlock()) instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            return holder.getContainer(blockAccessor.getBlockState(), (LevelAccessor)accessor.getLevel(), blockAccessor.getPosition());
        }
        if (target instanceof Container) {
            Container container = (Container)target;
            return container;
        }
        return null;
    }

    @Nullable
    public static List<ViewGroup<FluidView.Data>> wrapFluidStorage(Accessor<?> accessor) {
        IFluidHandler fluidHandler = (IFluidHandler)CommonProxy.getDefaultStorage(accessor, Capabilities.FluidHandler.BLOCK, Capabilities.FluidHandler.ENTITY);
        if (fluidHandler != null) {
            return JadeForgeUtils.fromFluidHandler(fluidHandler);
        }
        return null;
    }

    @Nullable
    public static List<ViewGroup<EnergyView.Data>> wrapEnergyStorage(Accessor<?> accessor) {
        IEnergyStorage energyStorage = (IEnergyStorage)CommonProxy.getDefaultStorage(accessor, Capabilities.EnergyStorage.BLOCK, Capabilities.EnergyStorage.ENTITY);
        if (energyStorage != null) {
            ViewGroup<EnergyView.Data> group = new ViewGroup<EnergyView.Data>(List.of(new EnergyView.Data(energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored())));
            group.getExtraData().putString("Unit", "FE");
            return List.of(group);
        }
        return null;
    }

    public static boolean isDevEnv() {
        return !FMLEnvironment.production;
    }

    public static ResourceLocation getId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static ResourceLocation getId(BlockEntityType<?> blockEntityType) {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType);
    }

    public static String getPlatformIdentifier() {
        return "neoforge";
    }

    private static void registerServerCommand(RegisterCommandsEvent event) {
        JadeServerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static boolean isBoss(Entity entity) {
        EntityType entityType = entity.getType();
        return entityType.is(Tags.EntityTypes.BOSSES) || entityType == EntityType.ENDER_DRAGON || entityType == EntityType.WITHER;
    }

    public static ItemStack getBlockPickedResult(BlockState state, Player player, BlockHitResult hitResult) {
        return state.getCloneItemStack((LevelReader)player.level(), hitResult.getBlockPos(), true);
    }

    public static ItemStack getEntityPickedResult(Entity entity, Player player, EntityHitResult hitResult) {
        return (ItemStack)MoreObjects.firstNonNull((Object)entity.getPickResult(), (Object)ItemStack.EMPTY);
    }

    public static boolean isModLoaded(String modid) {
        try {
            ModList modList = ModList.get();
            if (modList == null) {
                return LoadingModList.get().getModFileById(modid) != null;
            }
            return modList.isLoaded(modid);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Optional<String> getModVersion(String modid) {
        return ModList.get().getModContainerById(modid).map($ -> MavenVersionTranslator.artifactVersionToString((ArtifactVersion)$.getModInfo().getVersion()));
    }

    public static void loadComplete() {
        Jade.loadPlugins();
    }

    public static List<Entrypoint> loadEntrypoints() {
        ArrayList entrypoints = Lists.newArrayList();
        for (ModContainer container : ModList.get().getSortedMods()) {
            IModFileInfo owningFile = container.getModInfo().getOwningFile();
            if (owningFile == null) continue;
            owningFile.getFile().getScanResult().getAnnotatedBy(WailaPlugin.class, ElementType.TYPE).map($ -> new Entrypoint(container, (ModFileScanData.AnnotationData)$)).forEach(entrypoints::add);
        }
        return entrypoints;
    }

    public static Component getFluidName(JadeFluidObject fluid) {
        return CommonProxy.toFluidStack(fluid).getHoverName();
    }

    public static FluidStack toFluidStack(JadeFluidObject fluid) {
        int id = BuiltInRegistries.FLUID.getId((Object)fluid.getType());
        Optional holder = BuiltInRegistries.FLUID.get(id);
        if (holder.isEmpty()) {
            return FluidStack.EMPTY;
        }
        long amount = fluid.getAmount();
        if (amount > Integer.MAX_VALUE) {
            amount = Integer.MAX_VALUE;
        }
        return new FluidStack((Holder)holder.get(), (int)amount, fluid.getComponents());
    }

    public static boolean isMultipartEntity(Entity target) {
        return target.isMultipartEntity();
    }

    public static Entity wrapPartEntityParent(Entity target) {
        if (target instanceof PartEntity) {
            PartEntity part = (PartEntity)target;
            return part.getParent();
        }
        return target;
    }

    public static int getPartEntityIndex(Entity entity) {
        if (!(entity instanceof PartEntity)) {
            return -1;
        }
        PartEntity part = (PartEntity)entity;
        Entity parent = CommonProxy.wrapPartEntityParent(entity);
        PartEntity[] parts = parent.getParts();
        if (parts == null) {
            return -1;
        }
        return List.of(parts).indexOf(part);
    }

    public static Entity getPartEntity(Entity parent, int index) {
        if (parent == null) {
            return null;
        }
        if (index < 0) {
            return parent;
        }
        PartEntity[] parts = parent.getParts();
        if (parts == null || index >= parts.length) {
            return parent;
        }
        return parts[index];
    }

    public static <T> T getDefaultStorage(Accessor<?> accessor, BlockCapability<T, ?> blockCapability, EntityCapability<T, ?> entityCapability) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return (T)accessor.getLevel().getCapability(blockCapability, blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null);
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor entityAccessor = (EntityAccessor)accessor;
            return (T)entityAccessor.getEntity().getCapability(entityCapability, null);
        }
        return null;
    }

    public static <T> boolean hasDefaultStorage(Accessor<?> accessor, BlockCapability<T, ?> blockCapability, EntityCapability<T, ?> entityCapability) {
        if (accessor instanceof BlockAccessor || accessor instanceof EntityAccessor) {
            return CommonProxy.getDefaultStorage(accessor, blockCapability, entityCapability) != null;
        }
        return true;
    }

    public static boolean hasDefaultItemStorage(Accessor<?> accessor) {
        BlockAccessor blockAccessor;
        if (accessor.getTarget() == null && accessor instanceof BlockAccessor && (blockAccessor = (BlockAccessor)accessor).getBlock() instanceof WorldlyContainerHolder) {
            return true;
        }
        return CommonProxy.hasDefaultStorage(accessor, Capabilities.ItemHandler.BLOCK, Capabilities.ItemHandler.ENTITY);
    }

    public static boolean hasDefaultFluidStorage(Accessor<?> accessor) {
        return CommonProxy.hasDefaultStorage(accessor, Capabilities.FluidHandler.BLOCK, Capabilities.FluidHandler.ENTITY);
    }

    public static boolean hasDefaultEnergyStorage(Accessor<?> accessor) {
        return CommonProxy.hasDefaultStorage(accessor, Capabilities.EnergyStorage.BLOCK, Capabilities.EnergyStorage.ENTITY);
    }

    public static long bucketVolume() {
        return 1000L;
    }

    public static long blockVolume() {
        return 1000L;
    }

    public static void registerTagsUpdatedListener(BiConsumer<HolderLookup.Provider, Boolean> listener) {
        NeoForge.EVENT_BUS.addListener(event -> listener.accept(event.getLookupProvider(), event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCorrectConditions(List<LootItemCondition> conditions, ItemStack toolItem) {
        LootItemCondition child;
        if (conditions.size() != 1) {
            return false;
        }
        LootItemCondition condition = conditions.getFirst();
        if (condition instanceof MatchTool) {
            Optional predicate;
            MatchTool matchTool = (MatchTool)condition;
            try {
                Optional optional;
                predicate = optional = matchTool.predicate();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ItemPredicate itemPredicate = predicate.orElse(null);
            if (itemPredicate == null) return false;
            if (!itemPredicate.test(toolItem)) return false;
            return true;
        }
        if (!(condition instanceof AnyOfCondition)) return false;
        AnyOfCondition anyOfCondition = (AnyOfCondition)condition;
        Iterator iterator = anyOfCondition.terms.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!CommonProxy.isCorrectConditions(List.of(child = (LootItemCondition)iterator.next()), toolItem));
        return true;
    }

    public static <T> Map.Entry<ResourceLocation, List<ViewGroup<T>>> getServerExtensionData(Accessor<?> accessor, WrappedHierarchyLookup<IServerExtensionProvider<T>> lookup) {
        for (IServerExtensionProvider<T> provider : lookup.wrappedGet(accessor)) {
            List<ViewGroup<T>> groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null);
                continue;
            }
            if (groups == null) continue;
            return Map.entry(provider.getUid(), groups);
        }
        return null;
    }

    public CommonProxy(IEventBus modBus) {
        modBus.addListener(FMLLoadCompleteEvent.class, event -> event.enqueueWork(CommonProxy::loadComplete));
        modBus.addListener(RegisterPayloadHandlersEvent.class, event -> event.registrar("jade").versioned("8").optional().playToClient(ReceiveDataPacket.TYPE, ReceiveDataPacket.CODEC, (payload, context) -> ReceiveDataPacket.handle(payload, arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0))).playToServer(RequestEntityPacket.TYPE, RequestEntityPacket.CODEC, (payload, context) -> RequestEntityPacket.handle(payload, () -> (ServerPlayer)context.player())).playToServer(RequestBlockPacket.TYPE, RequestBlockPacket.CODEC, (payload, context) -> RequestBlockPacket.handle(payload, () -> (ServerPlayer)context.player())).playToServer(ClientHandshakePacket.TYPE, ClientHandshakePacket.CODEC, (payload, context) -> ClientHandshakePacket.handle(payload, () -> (ServerPlayer)context.player())).playToClient(ServerHandshakePacket.TYPE, ServerHandshakePacket.CODEC, (payload, context) -> ServerHandshakePacket.handle(payload, arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0))).playToClient(ShowOverlayPacket.TYPE, ShowOverlayPacket.CODEC, (payload, context) -> ShowOverlayPacket.handle(payload, arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0))));
        NeoForge.EVENT_BUS.addListener(CommonProxy::registerServerCommand);
        if (CommonProxy.isPhysicallyClient()) {
            ClientProxy.init(modBus);
        }
    }

    public static String defaultEnergyUnit() {
        return "E";
    }

    public static void sendPacket(ServerPlayer player, CustomPacketPayload payload) {
        player.connection.send(payload);
    }

    public static boolean isSheared(Entity entity) {
        Shearable shearable;
        if (entity instanceof Shearable && !(shearable = (Shearable)entity).readyForShearing()) {
            if (entity instanceof Sheep || entity instanceof MushroomCow) {
                return !((Animal)entity).isBaby();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static Either<String, Component> getTranslatableName(Object object) {
        if (object instanceof TranslatableEnum) {
            TranslatableEnum translatableEnum = (TranslatableEnum)object;
            return Either.right((Object)translatableEnum.getTranslatedName());
        }
        return null;
    }

    public record Entrypoint(ModContainer container, ModFileScanData.AnnotationData annotationData) {
        public String className() {
            return this.annotationData.memberName();
        }

        public String modId() {
            return this.container.getModId();
        }

        public String modName() {
            return this.container.getModInfo().getDisplayName();
        }

        public String requiredMod() {
            return this.annotationData.annotationData().getOrDefault("value", "").toString();
        }

        public IWailaPlugin newInstance() {
            try {
                return (IWailaPlugin)Class.forName(this.className()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                this.throwError("Failed to instantiate plugin class");
                throw new AssertionError();
            }
        }

        public void throwError(String message, @Nullable Throwable cause) {
            message = "Error in plugin class %s from %s: %s".formatted(this.className(), this.modName(), message);
            cause = cause == null ? new IllegalStateException(message) : new IllegalStateException(message, cause);
            throw new TraceableException(cause, this.modId());
        }

        public void throwError(String message) {
            this.throwError(message, null);
        }
    }
}

