/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.netherportalfix.ReturnPortal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalForcer;
import org.jetbrains.annotations.Nullable;

public class ReturnPortalManager {
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String RETURN_PORTAL_LIST = "ReturnPortalList";
    private static final String RETURN_PORTAL_UID = "UID";
    private static final String FROM_DIM = "FromDim";
    private static final String FROM_POS = "FromPos";
    private static final String TO_POS = "ToPos";

    public static BlockPos findPortalAt(Player player, ResourceKey<Level> dim, BlockPos pos) {
        ServerLevel fromWorld;
        MinecraftServer server = player.level().getServer();
        if (server != null && (fromWorld = server.getLevel(dim)) != null) {
            PortalForcer portalForcer = fromWorld.getPortalForcer();
            return portalForcer.findClosestPortalPosition(pos, false, fromWorld.getWorldBorder()).orElse(null);
        }
        return null;
    }

    public static ListTag getPlayerPortalList(Entity entity) {
        CompoundTag data = Balm.getHooks().getPersistentData(entity);
        ListTag list = data.getListOrEmpty(RETURN_PORTAL_LIST);
        data.put(RETURN_PORTAL_LIST, (Tag)list);
        return list;
    }

    @Nullable
    public static ReturnPortal findReturnPortal(Entity entity, ResourceKey<Level> fromDim, BlockPos fromPos) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList(entity);
        for (Tag entry : portalList) {
            BlockPos portalTrigger;
            CompoundTag portal = (CompoundTag)entry;
            ResourceKey entryFromDim = portal.getString(FROM_DIM).map(ResourceLocation::parse).map(it -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)it)).orElse(null);
            if (entryFromDim != fromDim || (portalTrigger = (BlockPos)portal.getLong(FROM_POS).map(BlockPos::of).orElse(null)) == null || !(portalTrigger.distSqr((Vec3i)fromPos) <= 16.0)) continue;
            UUID uid = portal.read(RETURN_PORTAL_UID, UUIDUtil.CODEC).orElseGet(UUID::randomUUID);
            BlockPos pos = portal.getLong(TO_POS).map(BlockPos::of).orElse(null);
            if (pos == null) continue;
            return new ReturnPortal(uid, pos);
        }
        return null;
    }

    public static void storeReturnPortal(ServerPlayer player, ResourceKey<Level> fromDim, BlockPos fromPos, BlockPos toPos) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Entity)player);
        ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal((Entity)player, fromDim, fromPos);
        if (returnPortal != null) {
            ReturnPortalManager.removeReturnPortal(player, returnPortal);
        }
        CompoundTag portalCompound = new CompoundTag();
        portalCompound.store(RETURN_PORTAL_UID, UUIDUtil.CODEC, (Object)UUID.randomUUID());
        portalCompound.putString(FROM_DIM, String.valueOf(fromDim.location()));
        portalCompound.putLong(FROM_POS, fromPos.asLong());
        portalCompound.putLong(TO_POS, toPos.asLong());
        portalList.add((Object)portalCompound);
    }

    public static void removeReturnPortal(ServerPlayer player, ReturnPortal portal) {
        ListTag portalList = ReturnPortalManager.getPlayerPortalList((Entity)player);
        for (int i = 0; i < portalList.size(); ++i) {
            CompoundTag entry = (CompoundTag)portalList.get(i);
            if (!entry.read(RETURN_PORTAL_UID, UUIDUtil.CODEC).map(it -> it.equals(portal.getUid())).orElse(false).booleanValue()) continue;
            portalList.remove(i);
            break;
        }
    }
}

