/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GNSConfig {
    public static final ModConfigSpec WORLD_SPEC;
    public static final WorldConfig WORLD;

    protected static String translationKey(String key) {
        return "good_nights_sleep." + key;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(WorldConfig::new);
        WORLD = (WorldConfig)pair.getLeft();
        WORLD_SPEC = (ModConfigSpec)pair.getRight();
    }

    public static class WorldConfig {
        private final ModConfigSpec.ConfigValue<Boolean> allowNightmarePhantoms;
        private final ModConfigSpec.ConfigValue<Boolean> limitSleepTime;

        public WorldConfig(ModConfigSpec.Builder builder) {
            this.allowNightmarePhantoms = builder.translation(WorldConfig.key("allow_nightmare_phantoms")).comment("Allows Phantoms to spawn in the Nightmare dimension.").define("allow_nightmare_phantoms", true);
            this.limitSleepTime = builder.translation(WorldConfig.key("limit_sleep_time")).comment("Limits use of the mod's beds to night-time.").define("limit_sleep_time", false);
        }

        public boolean allowNightmarePhantoms() {
            return (Boolean)this.allowNightmarePhantoms.get();
        }

        public boolean limitSleepTime() {
            return (Boolean)this.limitSleepTime.get();
        }

        public static String key(String key) {
            return GNSConfig.translationKey("server") + "." + key;
        }
    }

    public static class CommonConfig {
        public CommonConfig(ModConfigSpec.Builder builder) {
        }

        public static String key(String key) {
            return GNSConfig.translationKey("common") + "." + key;
        }
    }

    public static class ClientConfig {
        public ClientConfig(ModConfigSpec.Builder builder) {
        }

        public static String key(String key) {
            return GNSConfig.translationKey("client") + "." + key;
        }
    }
}

