/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.good_nights_sleep;

import com.legacy.good_nights_sleep.GNSConfig;
import com.legacy.good_nights_sleep.blocks.util.Flamibility;
import com.legacy.good_nights_sleep.blocks.util.ToolCompat;
import com.legacy.good_nights_sleep.client.GNSClientEvents;
import com.legacy.good_nights_sleep.client.render.GNSEntityRendering;
import com.legacy.good_nights_sleep.client.resource_pack.GNSResourcePackHandler;
import com.legacy.good_nights_sleep.commands.GNSCommand;
import com.legacy.good_nights_sleep.data.GNSBlockTags;
import com.legacy.good_nights_sleep.data.GNSItemTags;
import com.legacy.good_nights_sleep.event.GNSEvents;
import com.legacy.good_nights_sleep.event.GNSPlayerEvents;
import com.legacy.good_nights_sleep.registry.GNSDimensions;
import com.legacy.good_nights_sleep.registry.GNSEntityTypes;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="good_nights_sleep")
public class GoodNightSleep {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String NAME = "Good Night's Sleep";
    public static final String MODID = "good_nights_sleep";
    public static final String PACKET_VERSION = "1.4.0";
    public static final String OLD_MODID = "goodnightsleep";

    public static ResourceLocation locate(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name);
    }

    public static ResourceLocation locateOld(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)OLD_MODID, (String)name);
    }

    public static String find(String name) {
        return "good_nights_sleep:" + name;
    }

    public GoodNightSleep(IEventBus modBus, ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)GNSConfig.WORLD_SPEC);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            GNSEntityRendering.init(modBus);
            modBus.addListener(GNSClientEvents::initDimensionRenderInfo);
            modBus.addListener(GNSClientEvents::registerDimensionTransitions);
            modBus.addListener(GNSResourcePackHandler::packRegistry);
            modBus.addListener(GNSClientEvents::registerOverlays);
            NeoForge.EVENT_BUS.register(GNSClientEvents.class);
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        GNSDimensions.init();
        modBus.addListener(GoodNightSleep::commonInit);
        modBus.addListener(GNSEntityTypes::onAttributesRegistered);
        modBus.addListener(EventPriority.LOWEST, GNSEntityTypes::registerPlacements);
        modBus.addListener(GNSEntityTypes::registerPlacementOverrides);
    }

    private static void commonInit(FMLCommonSetupEvent event) {
        IEventBus forge = NeoForge.EVENT_BUS;
        forge.register(GNSEvents.class);
        forge.register(GNSPlayerEvents.class);
        forge.addListener(cmdEvent -> GNSCommand.register((CommandDispatcher<CommandSourceStack>)cmdEvent.getDispatcher()));
        ToolCompat.init();
        GNSBlockTags.init();
        GNSItemTags.init();
        event.enqueueWork(() -> {
            Flamibility.init();
            BuiltInRegistries.BLOCK.addAlias(GoodNightSleep.locate("dream_grass"), GoodNightSleep.locate("short_dream_grass"));
            BuiltInRegistries.BLOCK.addAlias(GoodNightSleep.locate("nightmare_grass"), GoodNightSleep.locate("short_nightmare_grass"));
            BuiltInRegistries.ITEM.addAlias(GoodNightSleep.locate("dream_grass"), GoodNightSleep.locate("short_dream_grass"));
            BuiltInRegistries.ITEM.addAlias(GoodNightSleep.locate("nightmare_grass"), GoodNightSleep.locate("short_nightmare_grass"));
        });
    }
}

